/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.ClientType;
import jakarta.faces.context.FacesContext;
import java.util.Map;
import java.util.StringTokenizer;

public final class ClientSniffer {
    private String agent = null;
    private int major = -1;

    public ClientSniffer(FacesContext context) {
        StringTokenizer st;
        String version = null;
        this.setUserAgent(context);
        this.agent = this.getUserAgent();
        if (this.agent != null) {
            st = new StringTokenizer(this.agent, "/");
            if (st.hasMoreTokens()) {
                st.nextToken();
            }
            if (st.hasMoreTokens()) {
                version = st.nextToken();
            }
            if (version != null && (st = new StringTokenizer(version)).hasMoreTokens()) {
                version = st.nextToken();
            }
        }
        if (version != null && (st = new StringTokenizer(version, ".")).hasMoreTokens()) {
            try {
                this.major = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public static ClientSniffer getInstance(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        ClientSniffer sniffer = (ClientSniffer)requestMap.get("__sniffer");
        if (sniffer == null) {
            sniffer = new ClientSniffer(context);
            requestMap.put("__sniffer", sniffer);
        }
        return sniffer;
    }

    protected void setUserAgent(FacesContext context) {
        Map headerMap = context.getExternalContext().getRequestHeaderMap();
        if (null != headerMap) {
            this.agent = (String)headerMap.get("USER-AGENT");
            if (null != this.agent) {
                this.agent = this.agent.toLowerCase();
            }
        }
    }

    public String getUserAgent() {
        return this.agent;
    }

    public int getUserAgentMajor() {
        return this.major;
    }

    public boolean isWin() {
        boolean result = false;
        if (this.agent != null && (this.agent.contains("win") || this.agent.contains("16bit"))) {
            result = true;
        }
        return result;
    }

    public boolean isSun() {
        boolean result = false;
        if (this.agent != null && this.agent.contains("sunos")) {
            result = true;
        }
        return result;
    }

    public boolean isGecko() {
        boolean result = false;
        if (this.agent != null && this.agent.contains("gecko")) {
            result = true;
        }
        return result;
    }

    public boolean isNav() {
        boolean result = false;
        if (!(this.agent == null || !this.agent.contains("mozilla") || !this.agent.contains("spoofer") || this.agent.contains("compatible") || this.agent.contains("opera") || this.agent.contains("webtv") || this.agent.contains("hotjava") || this.isGecko() && !this.agent.contains("netscape"))) {
            result = true;
        }
        return result;
    }

    public boolean isNav4() {
        boolean result = false;
        if (this.isNav() && this.major == 4) {
            result = true;
        }
        return result;
    }

    public boolean isNav4up() {
        boolean result = false;
        if (this.isNav() && this.major >= 4) {
            result = true;
        }
        return result;
    }

    public boolean isNav6() {
        boolean result = false;
        if (this.isNav() && this.major == 5 && null != this.agent && this.agent.contains("netscape6")) {
            result = true;
        }
        return result;
    }

    public boolean isNav6up() {
        boolean result = false;
        if (this.isNav() && this.major >= 5) {
            result = true;
        }
        return result;
    }

    public boolean isNav7() {
        boolean result = false;
        if (this.isNav() && this.major == 5 && null != this.agent && this.agent.contains("netscape/7")) {
            result = true;
        }
        return result;
    }

    public boolean isNav70() {
        boolean result = false;
        if (this.isNav() && this.major == 5 && null != this.agent && this.agent.contains("netscape/7.0")) {
            result = true;
        }
        return result;
    }

    public boolean isNav7up() {
        boolean result = false;
        if (this.isNav() && this.major >= 5 && !this.isNav4() && !this.isNav6()) {
            result = true;
        }
        return result;
    }

    public boolean isIe() {
        boolean result = false;
        if (this.agent != null && this.agent.contains("msie") && !this.agent.contains("opera")) {
            result = true;
        }
        return result;
    }

    public boolean isIe3() {
        boolean result = false;
        if (this.isIe() && this.major < 4) {
            result = true;
        }
        return result;
    }

    public boolean isIe4() {
        boolean result = false;
        if (this.isIe() && this.major == 4 && null != this.agent && this.agent.contains("msie 4")) {
            result = true;
        }
        return result;
    }

    public boolean isIe5() {
        boolean result = false;
        if (this.isIe() && this.major == 4 && null != this.agent && this.agent.contains("msie 5")) {
            result = true;
        }
        return result;
    }

    public boolean isIe5up() {
        boolean result = false;
        if (this.isIe() && !this.isIe3() && !this.isIe4()) {
            result = true;
        }
        return result;
    }

    public boolean isIe6() {
        boolean result = false;
        if (this.isIe() && this.major == 4 && null != this.agent && this.agent.contains("msie 6")) {
            result = true;
        }
        return result;
    }

    public boolean isIe7() {
        boolean result = false;
        if (this.isIe() && this.major == 4 && null != this.agent && this.agent.contains("msie 7")) {
            result = true;
        }
        return result;
    }

    public boolean isIe6up() {
        boolean result = false;
        if (this.isIe() && !this.isIe3() && !this.isIe4() && !this.isIe5()) {
            result = true;
        }
        return result;
    }

    public boolean isIe7up() {
        boolean result = false;
        if (!(!this.isIe() || this.isIe3() || this.isIe4() || this.isIe5() || this.isIe6())) {
            result = true;
        }
        return result;
    }

    public static ClientType getClientType(FacesContext context) {
        Map map = context.getExternalContext().getRequestHeaderMap();
        if (null == map) {
            return ClientType.OTHER;
        }
        String agent = (String)map.get("USER-AGENT");
        if (agent == null) {
            return ClientType.OTHER;
        }
        if ((agent = agent.toLowerCase()).contains("safari")) {
            return ClientType.SAFARI;
        }
        if (agent.contains("gecko")) {
            return ClientType.GECKO;
        }
        if (agent.contains("msie 7")) {
            return ClientType.IE7;
        }
        if (agent.contains("msie 6")) {
            return ClientType.IE6;
        }
        if (agent.contains("msie 5.5")) {
            return ClientType.IE5_5;
        }
        return ClientType.OTHER;
    }
}

