/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.impl.common;

import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.glassfish.security.services.api.common.Attribute;
import org.glassfish.security.services.api.common.Attributes;
import org.glassfish.security.services.impl.common.AttributeImpl;

public class AttributesImpl
implements Attributes {
    private final TreeMap<String, Attribute> attributes;

    public AttributesImpl() {
        this.attributes = new TreeMap();
    }

    public AttributesImpl(AttributesImpl other) {
        if (other == null) {
            throw new NullPointerException("Given illegal null AttributesImpl.");
        }
        this.attributes = new TreeMap<String, Attribute>((SortedMap<String, Attribute>)other.attributes);
    }

    @Override
    public int getAttributeCount() {
        return this.attributes.size();
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    @Override
    public Attribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public String getAttributeValue(String name) {
        Attribute attribute = this.attributes.get(name);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    @Override
    public Set<String> getAttributeValues(String name) {
        Attribute attribute = this.attributes.get(name);
        if (attribute != null) {
            return attribute.getValues();
        }
        return null;
    }

    @Override
    public String[] getAttributeValuesAsArray(String name) {
        Attribute attribute = this.attributes.get(name);
        if (attribute != null) {
            return attribute.getValuesAsArray();
        }
        return null;
    }

    @Override
    public void addAttribute(String name, String value, boolean replace) {
        Attribute attribute = this.attributes.get(name);
        if (attribute != null && !replace) {
            attribute.addValue(value);
        } else {
            this.attributes.put(name, new AttributeImpl(name, value));
        }
    }

    @Override
    public void addAttribute(String name, Set<String> values, boolean replace) {
        Attribute attribute = this.attributes.get(name);
        if (attribute != null && !replace) {
            attribute.addValues(values);
        } else {
            this.attributes.put(name, new AttributeImpl(name, values));
        }
    }

    @Override
    public void addAttribute(String name, String[] values, boolean replace) {
        Attribute attribute = this.attributes.get(name);
        if (attribute != null && !replace) {
            attribute.addValues(values);
        } else {
            this.attributes.put(name, new AttributeImpl(name, values));
        }
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public void removeAttributeValue(String name, String value) {
        Attribute attribute = this.attributes.get(name);
        if (attribute != null) {
            attribute.removeValue(value);
        }
    }

    @Override
    public void removeAttributeValues(String name, Set<String> values) {
        Attribute attribute = this.attributes.get(name);
        if (attribute != null) {
            attribute.removeValues(values);
        }
    }

    @Override
    public void removeAttributeValues(String name, String[] values) {
        Attribute attribute = this.attributes.get(name);
        if (attribute != null) {
            attribute.removeValues(values);
        }
    }

    @Override
    public void removeAllAttributeValues(String name) {
        Attribute attribute = this.attributes.get(name);
        if (attribute != null) {
            attribute.clear();
        }
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }
}

