/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ConnectorXAResource;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.resource.XAResourceWrapper;
import com.sun.enterprise.resource.allocator.LocalTxConnectorAllocator;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.transaction.spi.TransactionalResource;
import com.sun.logging.LogDomains;
import jakarta.resource.spi.ConnectionEventListener;
import jakarta.resource.spi.DissociatableManagedConnection;
import jakarta.resource.spi.LazyEnlistableManagedConnection;
import jakarta.resource.spi.ManagedConnection;
import jakarta.transaction.Transaction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAResource;

public class ResourceHandle
implements com.sun.appserv.connectors.internal.api.ResourceHandle,
TransactionalResource {
    private static final Logger logger = LogDomains.getLogger(ResourceHandle.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private static long idSequence;
    private final long id;
    private final ManagedConnection resource;
    private ResourceSpec resourceSpec;
    private XAResource xaResource;
    private Object userConnection;
    private final ResourceAllocator resourceAllocator;
    private Object instance;
    private int shareCount;
    private final ResourceState state = new ResourceState();
    private ConnectionEventListener listener;
    private boolean enlistmentSuspended;
    private final boolean supportsXAResource;
    private boolean supportsLazyEnlistment;
    private boolean supportsLazyAssociation;
    public final Object lock = new Object();
    private long lastValidated;
    private int usageCount;
    private int rwLockDataStructureResourceIndex;
    private boolean isDestroyByLeakTimeOut;
    private boolean connectionErrorOccurred;
    private boolean markedReclaim;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getNextId() {
        Class<ResourceHandle> clazz = ResourceHandle.class;
        synchronized (ResourceHandle.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ++idSequence;
        }
    }

    public ResourceHandle(ManagedConnection resource, ResourceSpec resourceSpec, ResourceAllocator resourceAllocator) {
        this.id = ResourceHandle.getNextId();
        this.resource = resource;
        this.resourceSpec = resourceSpec;
        this.resourceAllocator = resourceAllocator;
        this.supportsXAResource = !(resourceAllocator instanceof LocalTxConnectorAllocator);
        if (resource instanceof LazyEnlistableManagedConnection) {
            this.supportsLazyEnlistment = true;
        }
        if (resource instanceof DissociatableManagedConnection) {
            this.supportsLazyAssociation = true;
        }
    }

    public boolean isTransactional() {
        return this.resourceAllocator.isTransactional();
    }

    public boolean isEnlistmentSuspended() {
        return this.enlistmentSuspended;
    }

    public void setEnlistmentSuspended(boolean enlistmentSuspended) {
        this.enlistmentSuspended = enlistmentSuspended;
    }

    public void markForReclaim(boolean reclaim) {
        this.markedReclaim = reclaim;
    }

    public boolean isMarkedForReclaim() {
        return this.markedReclaim;
    }

    public boolean supportsXA() {
        return this.supportsXAResource;
    }

    public ResourceAllocator getResourceAllocator() {
        return this.resourceAllocator;
    }

    public ManagedConnection getResource() {
        return this.resource;
    }

    public void setResourceSpec(ResourceSpec resourceSpec) {
        this.resourceSpec = resourceSpec;
    }

    public ResourceSpec getResourceSpec() {
        return this.resourceSpec;
    }

    public XAResource getXAResource() {
        return this.xaResource;
    }

    public Object getUserConnection() {
        return this.userConnection;
    }

    public void setComponentInstance(Object instance) {
        this.instance = instance;
    }

    public void closeUserConnection() throws PoolingException {
        this.getResourceAllocator().closeUserConnection(this);
    }

    public Object getComponentInstance() {
        return this.instance;
    }

    public long getId() {
        return this.id;
    }

    public void fillInResourceObjects(Object userConnection, XAResource xaResource) {
        if (userConnection != null) {
            this.userConnection = userConnection;
        }
        if (xaResource != null) {
            this.xaResource = logger.isLoggable(Level.FINEST) ? (xaResource instanceof XAResourceWrapper || xaResource instanceof ConnectorXAResource ? xaResource : new XAResourceWrapper(xaResource)) : xaResource;
        }
    }

    public void incrementCount() {
        ++this.shareCount;
    }

    public void decrementCount() {
        if (this.shareCount == 0) {
            throw new IllegalStateException("shareCount cannot be negative");
        }
        --this.shareCount;
    }

    public int getShareCount() {
        return this.shareCount;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof ResourceHandle) {
            return this.id == ((ResourceHandle)other).id;
        }
        return false;
    }

    public int hashCode() {
        return Long.valueOf(this.id).hashCode();
    }

    public String toString() {
        return "<ResourceHandle id=" + this.id + ", state=" + String.valueOf(this.state) + "/>";
    }

    public void setConnectionErrorOccurred() {
        this.connectionErrorOccurred = true;
    }

    public boolean hasConnectionErrorOccurred() {
        return this.connectionErrorOccurred;
    }

    public ResourceState getResourceState() {
        return this.state;
    }

    public void setListener(ConnectionEventListener l) {
        this.listener = l;
    }

    public ConnectionEventListener getListener() {
        return this.listener;
    }

    public boolean isShareable() {
        return this.resourceAllocator.shareableWithinComponent();
    }

    public boolean isEnlisted() {
        return this.state.isEnlisted();
    }

    public long getLastValidated() {
        return this.lastValidated;
    }

    public void setLastValidated(long lastValidated) {
        this.lastValidated = lastValidated;
    }

    public int getUsageCount() {
        return this.usageCount;
    }

    public void incrementUsageCount() {
        ++this.usageCount;
    }

    public int getRwLockDataStructureResourceIndex() {
        return this.rwLockDataStructureResourceIndex;
    }

    public void setRwLockDataStructureResourceIndex(int rwLockDataStructureResourceIndex) {
        this.rwLockDataStructureResourceIndex = rwLockDataStructureResourceIndex;
    }

    public String getName() {
        return this.resourceSpec.getResourceId();
    }

    public boolean supportsLazyEnlistment() {
        return this.supportsLazyEnlistment;
    }

    public boolean supportsLazyAssociation() {
        return this.supportsLazyAssociation;
    }

    public void enlistedInTransaction(Transaction transaction) throws IllegalStateException {
        ConnectorRuntime.getRuntime().getPoolManager().resourceEnlisted(transaction, this);
    }

    public boolean getDestroyByLeakTimeOut() {
        return this.isDestroyByLeakTimeOut;
    }

    public void setDestroyByLeakTimeOut(boolean isDestroyByLeakTimeOut) {
        this.isDestroyByLeakTimeOut = isDestroyByLeakTimeOut;
    }
}

