/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.server.core.jws;

import java.net.URI;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.grizzly.http.server.Request;

public class Util {
    private static final Pattern TOKEN_SUBSTITUTION = Pattern.compile("\\$\\{([^\\}]*)\\}");
    private static final String SLASH_REPLACEMENT = Matcher.quoteReplacement("\\\\");
    private static final String DOLLAR_REPLACEMENT = Matcher.quoteReplacement("\\$");

    public static String replaceTokens(String s, Properties values) {
        Matcher m = TOKEN_SUBSTITUTION.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String propertyName = m.group(1);
            String propertyValue = values.getProperty(propertyName);
            if (propertyValue == null) continue;
            String adjustedPropertyValue = propertyValue.replaceAll("\\\\", SLASH_REPLACEMENT).replaceAll("\\$", DOLLAR_REPLACEMENT);
            String x = s.substring(m.start(), m.end());
            try {
                m.appendReplacement(sb, adjustedPropertyValue);
            }
            catch (IllegalArgumentException iae) {
                System.err.println("**** appendReplacement failed: segment is " + x + "; original replacement was " + propertyValue + " and adj. replacement is " + adjustedPropertyValue + "; exc follows");
                throw iae;
            }
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String toXMLEscapedInclAmp(String content) {
        return Util.toXMLEscaped(content.replaceAll("&", "&amp;"));
    }

    public static String toXMLEscaped(String content) {
        return content.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\"", "&quot;");
    }

    public static URI getCodebase(Request gReq) {
        return URI.create(gReq.getScheme() + "://" + gReq.getServerName());
    }
}

