/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.threadpool;

import com.sun.corba.ee.impl.threadpool.Exceptions;
import com.sun.corba.ee.impl.threadpool.ThreadPoolImpl;
import com.sun.corba.ee.spi.threadpool.NoSuchThreadPoolException;
import com.sun.corba.ee.spi.threadpool.ThreadPool;
import com.sun.corba.ee.spi.threadpool.ThreadPoolChooser;
import com.sun.corba.ee.spi.threadpool.ThreadPoolManager;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadPoolManagerImpl
implements ThreadPoolManager {
    public static final String THREADPOOL_DEFAULT_NAME = "default-threadpool";
    private ThreadPool threadPool;
    private ThreadGroup threadGroup = this.getThreadGroup();
    private static AtomicInteger tgCount = new AtomicInteger();

    public ThreadPoolManagerImpl() {
        this.threadPool = new ThreadPoolImpl(this.threadGroup, THREADPOOL_DEFAULT_NAME);
    }

    private ThreadGroup getThreadGroup() {
        ThreadGroup tg;
        try {
            tg = AccessController.doPrivileged(new PrivilegedAction<ThreadGroup>(){

                @Override
                public ThreadGroup run() {
                    ThreadGroup tg;
                    ThreadGroup ptg = tg = Thread.currentThread().getThreadGroup();
                    try {
                        while (ptg != null) {
                            tg = ptg;
                            ptg = tg.getParent();
                        }
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return new ThreadGroup(tg, "ORB ThreadGroup " + tgCount.getAndIncrement());
                }
            });
        }
        catch (SecurityException e) {
            tg = Thread.currentThread().getThreadGroup();
        }
        return tg;
    }

    @Override
    public void close() {
        try {
            this.threadPool.close();
        }
        catch (IOException exc) {
            Exceptions.self.threadPoolCloseError();
        }
        try {
            boolean isDestroyed = this.threadGroup.isDestroyed();
            int numThreads = this.threadGroup.activeCount();
            int numGroups = this.threadGroup.activeGroupCount();
            if (isDestroyed) {
                Exceptions.self.threadGroupIsDestroyed(this.threadGroup);
            } else {
                if (numThreads > 0) {
                    Exceptions.self.threadGroupHasActiveThreadsInClose(this.threadGroup, numThreads);
                }
                if (numGroups > 0) {
                    Exceptions.self.threadGroupHasSubGroupsInClose(this.threadGroup, numGroups);
                }
                this.threadGroup.destroy();
            }
        }
        catch (IllegalThreadStateException exc) {
            Exceptions.self.threadGroupDestroyFailed(exc, this.threadGroup);
        }
        this.threadGroup = null;
    }

    @Override
    public ThreadPool getThreadPool(String threadpoolId) throws NoSuchThreadPoolException {
        return this.threadPool;
    }

    @Override
    public ThreadPool getThreadPool(int numericIdForThreadpool) throws NoSuchThreadPoolException {
        return this.threadPool;
    }

    @Override
    public int getThreadPoolNumericId(String threadpoolId) {
        return 0;
    }

    @Override
    public String getThreadPoolStringId(int numericIdForThreadpool) {
        return "";
    }

    @Override
    public ThreadPool getDefaultThreadPool() {
        return this.threadPool;
    }

    @Override
    public ThreadPoolChooser getThreadPoolChooser(String componentId) {
        return null;
    }

    @Override
    public ThreadPoolChooser getThreadPoolChooser(int componentIndex) {
        return null;
    }

    @Override
    public void setThreadPoolChooser(String componentId, ThreadPoolChooser aThreadPoolChooser) {
    }

    @Override
    public int getThreadPoolChooserNumericId(String componentId) {
        return 0;
    }
}

