/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.io.IOException;
import java.io.Reader;
import org.apache.derby.iapi.tools.i18n.LocalizedInput;
import org.apache.derby.iapi.tools.i18n.LocalizedOutput;
import org.apache.derby.impl.tools.ij.ijException;
import org.apache.derby.impl.tools.ij.utilMain;

public class StatementFinder {
    private Reader source;
    private StringBuffer statement = new StringBuffer();
    private int state;
    private boolean atEOF = false;
    private boolean peekEOF = false;
    private char peekChar;
    private boolean peeked = false;
    private LocalizedOutput promptwriter;
    private boolean doPrompt;
    private boolean continuedStatement;
    private static final int IN_STATEMENT = 0;
    private static final int IN_STRING = 1;
    private static final int IN_SQLCOMMENT = 2;
    private static final int END_OF_STATEMENT = 3;
    private static final int END_OF_INPUT = 4;
    private static final char MINUS = '-';
    private static final char SINGLEQUOTE = '\'';
    private static final char DOUBLEQUOTE = '\"';
    private static final char SEMICOLON = ';';
    private static final char NEWLINE = '\n';
    private static final char RETURN = '\r';
    private static final char SPACE = ' ';
    private static final char TAB = '\t';
    private static final char FORMFEED = '\f';
    private static final char SLASH = '/';
    private static final char ASTERISK = '*';

    public StatementFinder(LocalizedInput localizedInput, LocalizedOutput localizedOutput) {
        this.source = localizedInput;
        if (localizedOutput != null && localizedInput.isStandardInput()) {
            this.promptwriter = localizedOutput;
            this.doPrompt = true;
        } else {
            this.doPrompt = false;
        }
    }

    public void ReInit(LocalizedInput localizedInput) {
        try {
            this.source.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.source = localizedInput;
        this.state = 0;
        this.atEOF = false;
        this.peekEOF = false;
        this.peeked = false;
        this.doPrompt = localizedInput.isStandardInput() && this.promptwriter != null;
    }

    public void close() throws IOException {
        this.source.close();
    }

    public String nextStatement() {
        boolean bl = false;
        this.statement.setLength(0);
        if (this.state == 4) {
            return null;
        }
        this.state = 0;
        char c = this.peekChar();
        if (this.peekEOF()) {
            this.state = 4;
            return null;
        }
        if (this.whiteSpace(c)) {
            while (this.whiteSpace(this.peekChar()) && !this.peekEOF()) {
            }
            if (this.peekEOF()) {
                this.state = 4;
                return null;
            }
        }
        while (this.state != 3 && this.state != 4) {
            c = this.readChar();
            if (this.atEOF()) {
                this.state = 4;
                break;
            }
            if (c != '-') {
                this.continuedStatement = true;
            }
            switch (c) {
                case '-': {
                    this.readSingleLineComment(c);
                    break;
                }
                case '/': {
                    this.readBracketedComment();
                    break;
                }
                case '\"': 
                case '\'': {
                    this.readString(c);
                    break;
                }
                case ';': {
                    bl = true;
                    this.state = 3;
                    this.continuedStatement = false;
                    break;
                }
                case '\n': 
                case '\r': {
                    if (!this.doPrompt) break;
                    utilMain.doPrompt(false, this.promptwriter, "");
                    if (c != '\r' || this.peekChar() != '\n') break;
                    this.readChar();
                }
            }
        }
        if (bl) {
            this.statement.setLength(this.statement.length() - 1);
        }
        return this.statement.toString();
    }

    private boolean whiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f';
    }

    private void readBracketedComment() {
        char c = this.peekChar();
        if (this.peekEOF()) {
            return;
        }
        if (c != '*') {
            this.continuedStatement = true;
            return;
        }
        this.readChar();
        int n = 1;
        while (true) {
            c = this.readChar();
            if (this.atEOF()) {
                this.state = 0;
                return;
            }
            char c2 = this.peekChar();
            if (c == '/' && c2 == '*') {
                this.readChar();
                ++n;
                continue;
            }
            if (c == '*' && c2 == '/') {
                this.readChar();
                if (--n != 0) continue;
                this.state = 0;
                return;
            }
            if (c != '\n' && c != '\r' || !this.doPrompt) continue;
            utilMain.doPrompt(false, this.promptwriter, "");
            if (c != '\r' || c2 != '\n') continue;
            this.readChar();
        }
    }

    private void readSingleLineComment(char c) {
        char c2 = this.peekChar();
        if (this.peekEOF()) {
            return;
        }
        if (c2 != c) {
            this.continuedStatement = true;
            return;
        }
        this.readChar();
        this.state = 2;
        do {
            c2 = this.peekChar();
            if (this.peekEOF()) {
                this.state = 0;
                return;
            }
            switch (c2) {
                case '\n': 
                case '\r': {
                    this.readChar();
                    this.state = 0;
                    if (this.doPrompt) {
                        if (this.continuedStatement) {
                            utilMain.doPrompt(false, this.promptwriter, "");
                        } else {
                            utilMain.doPrompt(true, this.promptwriter, "");
                        }
                        if (c2 == '\r' && this.peekChar() == '\n') {
                            this.readChar();
                        }
                    }
                    return;
                }
            }
            this.readChar();
        } while (this.state == 2);
    }

    private void readString(char c) {
        this.state = 1;
        do {
            char c2 = this.readChar();
            if (this.atEOF()) {
                this.state = 4;
                return;
            }
            if (c2 != c) continue;
            this.state = 0;
            return;
        } while (this.state == 1);
    }

    private boolean atEOF() {
        return this.atEOF;
    }

    private boolean peekEOF() {
        return this.peekEOF;
    }

    private char readChar() {
        if (!this.peeked) {
            this.peekChar();
        }
        this.peeked = false;
        this.atEOF = this.peekEOF;
        if (!this.atEOF) {
            this.statement.append(this.peekChar);
        }
        return this.peekChar;
    }

    private char peekChar() {
        this.peeked = true;
        char c = '\u0000';
        try {
            int n = this.source.read();
            boolean bl = this.peekEOF = n == -1;
            if (!this.peekEOF) {
                c = (char)n;
            }
        }
        catch (IOException iOException) {
            throw ijException.iOException(iOException);
        }
        this.peekChar = c;
        return c;
    }
}

