/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.microprofile.health;

import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.glassfish.microprofile.health.GlassFishHealthCheckResponse;
import org.glassfish.microprofile.health.HealthCheckInfo;
import org.glassfish.microprofile.health.HealthReport;

@Singleton
public class HealthReporter {
    private static final String MP_DEFAULT_STARTUP_EMPTY_RESPONSE = "mp.health.default.startup.empty.response";
    private static final String MP_DEFAULT_READINESS_EMPTY_RESPONSE = "mp.health.default.readiness.empty.response";
    private static final String CONTEXT_KEY = "context";
    private static final Logger LOGGER = Logger.getLogger(HealthReporter.class.getName());
    private final Map<String, List<HealthCheckInfo>> applicationHealthChecks = new ConcurrentHashMap<String, List<HealthCheckInfo>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HealthCheckResponse callHealthCheck(HealthCheck healthCheck) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(healthCheck.getClass().getClassLoader());
            HealthCheckResponse healthCheckResponse = healthCheck.call();
            return healthCheckResponse;
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Health check failed", e);
            HealthCheckResponse healthCheckResponse = HealthReporter.buildHealthCheckResponse(healthCheck.getClass().getName(), e);
            return healthCheckResponse;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private static HealthCheckResponse addContextToResponse(HealthCheckResponse response, String contextName) {
        if (response instanceof GlassFishHealthCheckResponse) {
            GlassFishHealthCheckResponse gfResponse = (GlassFishHealthCheckResponse)response;
            return gfResponse.addData(CONTEXT_KEY, contextName);
        }
        return response;
    }

    private static HealthCheckResponse buildHealthCheckResponse(String name, Exception e) {
        return HealthCheckResponse.builder().down().name(name).withData("rootCause", e.getMessage()).build();
    }

    public HealthReport getReport(ReportKind reportKind) {
        HealthCheckResponse.Status emptyResponse = reportKind.getEmptyResponse();
        List<HealthCheckResponse> healthCheckResults = this.applicationHealthChecks.entrySet().stream().flatMap(entry -> {
            String contextName = (String)entry.getKey();
            return ((List)entry.getValue()).stream().filter(reportKind::filter).map(HealthCheckInfo::healthCheck).map(HealthReporter::callHealthCheck).map(response -> HealthReporter.addContextToResponse(response, (String)entry.getKey()));
        }).toList();
        HealthCheckResponse.Status overallStatus = healthCheckResults.isEmpty() ? emptyResponse : healthCheckResults.stream().map(HealthCheckResponse::getStatus).filter(arg_0 -> HealthCheckResponse.Status.DOWN.equals(arg_0)).findFirst().orElse(HealthCheckResponse.Status.UP);
        return new HealthReport(overallStatus, healthCheckResults);
    }

    public void addHealthCheck(String contextName, HealthCheckInfo healthCheck) {
        this.applicationHealthChecks.computeIfAbsent(contextName, k -> new CopyOnWriteArrayList()).add(healthCheck);
    }

    public void removeAllHealthChecksFrom(String contextName) {
        this.applicationHealthChecks.remove(contextName);
    }

    private static Optional<HealthCheckResponse.Status> getValue(String value) {
        try {
            return ConfigProvider.getConfig().getOptionalValue(value, String.class).map(HealthCheckResponse.Status::valueOf);
        }
        catch (IllegalStateException e) {
            return Optional.empty();
        }
    }

    public static enum ReportKind {
        LIVE,
        READY,
        STARTED,
        ALL;


        private HealthCheckResponse.Status getEmptyResponse() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> HealthReporter.getValue(HealthReporter.MP_DEFAULT_STARTUP_EMPTY_RESPONSE).orElse(HealthCheckResponse.Status.UP);
                case 1 -> HealthReporter.getValue(HealthReporter.MP_DEFAULT_READINESS_EMPTY_RESPONSE).orElse(HealthCheckResponse.Status.UP);
                case 2, 3 -> HealthCheckResponse.Status.UP;
            };
        }

        public boolean filter(HealthCheckInfo healthCheck) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> healthCheck.kind().contains((Object)HealthCheckInfo.Kind.LIVE);
                case 1 -> healthCheck.kind().contains((Object)HealthCheckInfo.Kind.READY);
                case 2 -> healthCheck.kind().contains((Object)HealthCheckInfo.Kind.STARTUP);
                case 3 -> true;
            };
        }
    }
}

