/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.store.backing.commands;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.ha.cache.command.Command;
import org.glassfish.shoal.ha.cache.util.CommandResponse;
import org.glassfish.shoal.ha.cache.util.ResponseMediator;

public class SizeResponseCommand<K, V>
extends Command {
    private static final Logger _logger = Logger.getLogger("org.glassfish.shoal.ha.cache.command.size");
    private long tokenId;
    private int size;
    private String originatingInstance;
    private String respondingInstanceName;

    public SizeResponseCommand() {
        super((byte)52);
        super.setKey("SizeResp:" + this.tokenId);
    }

    public SizeResponseCommand(String originatingInstance, long tokenId, int size) {
        this();
        this.originatingInstance = originatingInstance;
        this.tokenId = tokenId;
        this.size = size;
    }

    @Override
    protected boolean beforeTransmit() {
        this.setTargetName(this.originatingInstance);
        return this.originatingInstance != null;
    }

    public Object getCommandKey() {
        return "SizeResp:" + this.tokenId;
    }

    private void writeObject(ObjectOutputStream ros) throws IOException {
        ros.writeLong(this.tokenId);
        ros.writeInt(this.size);
        ros.writeUTF(this.dsc.getInstanceName());
    }

    private void readObject(ObjectInputStream ris) throws IOException {
        this.tokenId = ris.readLong();
        this.size = ris.readInt();
        this.respondingInstanceName = ris.readUTF();
    }

    @Override
    public void execute(String initiator) {
        ResponseMediator respMed = this.getDataStoreContext().getResponseMediator();
        CommandResponse resp = respMed.getCommandResponse(this.tokenId);
        if (resp != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, this.dsc.getInstanceName() + " executed size_response tokenId=" + this.tokenId + " value " + this.size);
            }
            resp.setRespondingInstanceName(this.respondingInstanceName);
            resp.setResult(this.size);
        }
    }

    @Override
    protected boolean isArtificialKey() {
        return true;
    }

    @Override
    public String toString() {
        return this.getName() + "(" + this.tokenId + ")";
    }
}

