/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.node.SaxParserHandler;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Service
public class SaxParserHandlerBundled
extends SaxParserHandler {
    private static final Logger LOG = DOLUtils.getDefaultLogger();
    private static final String BUNDLED_SCHEMA_ROOT = "/schemas";
    private static final String BUNDLED_DTD_ROOT = "/dtds";

    @Override
    public InputSource resolveEntity(String publicID, String systemID) throws SAXException {
        try {
            LOG.log(Level.FINEST, "Asked to resolve publicID={0}, systemID={1}", new Object[]{publicID, systemID});
            if (publicID == null) {
                if (systemID == null || systemID.lastIndexOf(47) == systemID.length()) {
                    return null;
                }
                InputSource result = this.openSchemaSource(systemID);
                if (result == null) {
                    return new InputSource(systemID);
                }
                return result;
            }
            if (SaxParserHandlerBundled.getMapping().containsKey(publicID)) {
                this.publicID = publicID;
                return this.openDTDSource(publicID);
            }
            if (systemID != null) {
                InputSource result = this.openSchemaSource(systemID);
                if (result == null) {
                    return this.openInputSource(BUNDLED_DTD_ROOT, systemID);
                }
                return result;
            }
            return null;
        }
        catch (Exception exc) {
            throw new SAXException("Could not resolve entity with systemID=" + systemID, exc);
        }
    }

    private InputSource openSchemaSource(String systemID) {
        return this.openInputSource(BUNDLED_SCHEMA_ROOT, systemID);
    }

    private InputSource openDTDSource(String publicID) {
        return this.openInputSource(BUNDLED_DTD_ROOT, SaxParserHandlerBundled.getMapping().get(publicID));
    }

    private InputSource openInputSource(String localRoot, String systemID) {
        InputStream stream;
        String targetID = localRoot + "/" + systemID.substring(systemID.lastIndexOf("/") + 1);
        URL url = this.getClass().getResource(targetID);
        if (url == null) {
            return null;
        }
        try {
            stream = url.openStream();
        }
        catch (IOException e) {
            return null;
        }
        InputSource source = new InputSource(stream);
        source.setSystemId(url.toString());
        return source;
    }
}

