/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap.cp;

import com.sun.enterprise.glassfish.bootstrap.cfg.StartupContextCfg;
import com.sun.enterprise.glassfish.bootstrap.cp.ClassPathBuilder;
import com.sun.enterprise.glassfish.bootstrap.cp.EmbeddedAdapter;
import com.sun.enterprise.glassfish.bootstrap.cp.EquinoxAdapter;
import com.sun.enterprise.glassfish.bootstrap.cp.FelixAdapter;
import com.sun.enterprise.glassfish.bootstrap.cp.KnopflerfishAdapter;
import com.sun.enterprise.glassfish.bootstrap.cp.OsgiPlatformAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class ClassLoaderBuilder {
    public static ClassLoader createOSGiFrameworkLauncherCL(StartupContextCfg cfg, ClassLoader parent) throws IOException {
        ClassLoader classLoader = ClassLoaderBuilder.getOsgiPlatformAdapter(cfg).addFrameworkJars(new ClassPathBuilder()).build(parent);
        String osgiPackages = classLoader.resources("META-INF/MANIFEST.MF").map(ClassLoaderBuilder::loadExports).collect(Collectors.joining(", "));
        System.err.println("OSGI framework packages:\n" + osgiPackages);
        String javaPackages = ClassLoaderBuilder.detectJavaPackages();
        System.err.println("JDK provided packages:\n" + javaPackages);
        cfg.setProperty("org.osgi.framework.system.packages", osgiPackages + ", " + javaPackages);
        return classLoader;
    }

    private static OsgiPlatformAdapter getOsgiPlatformAdapter(StartupContextCfg cfg) {
        switch (cfg.getPlatform()) {
            case Felix: {
                return new FelixAdapter(cfg);
            }
            case Knopflerfish: {
                return new KnopflerfishAdapter(cfg);
            }
            case Equinox: {
                return new EquinoxAdapter(cfg);
            }
            case Embedded: 
            case Static: {
                return new EmbeddedAdapter();
            }
        }
        throw new RuntimeException("Unsupported platform " + String.valueOf((Object)cfg.getPlatform()));
    }

    private static String loadExports(URL url) {
        String string;
        block8: {
            InputStream is = url.openStream();
            try {
                Manifest manifest = new Manifest(is);
                Attributes attributes = manifest.getMainAttributes();
                string = attributes.getValue("Export-Package");
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not parse manifest from " + String.valueOf(url), e);
                }
            }
            is.close();
        }
        return string;
    }

    private static String detectJavaPackages() {
        HashSet<String> packages = new HashSet<String>();
        for (Module module : ModuleLayer.boot().modules()) {
            ClassLoaderBuilder.addAllExportedPackages(module, packages);
        }
        return packages.stream().sorted().collect(Collectors.joining(", "));
    }

    private static void addAllExportedPackages(Module module, Set<String> packages) {
        for (String pkg : module.getPackages()) {
            if (!module.isExported(pkg) && !module.isOpen(pkg)) continue;
            packages.add(pkg);
        }
    }
}

