/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import java.util.Hashtable;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.asm.LocalVariable;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Identifier;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.ArrayAccessExpression;
import org.glassfish.rmic.tools.tree.AssignExpression;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.ExpressionStatement;
import org.glassfish.rmic.tools.tree.IdentifierExpression;
import org.glassfish.rmic.tools.tree.LocalMember;
import org.glassfish.rmic.tools.tree.Statement;
import org.glassfish.rmic.tools.tree.Vset;

public class VarDeclarationStatement
extends Statement {
    LocalMember field;
    Expression expr;

    public VarDeclarationStatement(long where, Expression expr) {
        super(108, where);
        this.expr = expr;
    }

    public VarDeclarationStatement(long where, LocalMember field, Expression expr) {
        super(108, where);
        this.field = field;
        this.expr = expr;
    }

    @Override
    Vset checkDeclaration(Environment env, Context ctx, Vset vset, int mod, Type t, Hashtable<Object, Object> exp) {
        if (this.labels != null) {
            env.error(this.where, "declaration.with.label", this.labels[0]);
        }
        if (this.field != null) {
            if (ctx.getLocalClass(this.field.getName()) != null && this.field.isInnerClass()) {
                env.error(this.where, "local.class.redefined", this.field.getName());
            }
            ctx.declare(env, this.field);
            if (this.field.isInnerClass()) {
                ClassDefinition body = this.field.getInnerClass();
                try {
                    vset = body.checkLocalClass(env, ctx, vset, null, null, null);
                }
                catch (ClassNotFound ee) {
                    env.error(this.where, "class.not.found", ee.name, opNames[this.op]);
                }
                return vset;
            }
            vset.addVar(this.field.number);
            return this.expr != null ? this.expr.checkValue(env, ctx, vset, exp) : vset;
        }
        Expression e = this.expr;
        if (e.op == 1) {
            this.expr = ((AssignExpression)e).right;
            e = ((AssignExpression)e).left;
        } else {
            this.expr = null;
        }
        boolean declError = t.isType(13);
        while (e.op == 48) {
            ArrayAccessExpression array = (ArrayAccessExpression)e;
            if (array.index != null) {
                env.error(array.index.where, "array.dim.in.type");
                declError = true;
            }
            e = array.right;
            t = Type.tArray(t);
        }
        if (e.op == 60) {
            Identifier id = ((IdentifierExpression)e).id;
            if (ctx.getLocalField(id) != null) {
                env.error(this.where, "local.redefined", id);
            }
            this.field = new LocalMember(e.where, ctx.field.getClassDefinition(), mod, t, id);
            ctx.declare(env, this.field);
            if (this.expr != null) {
                vset = this.expr.checkInitializer(env, ctx, vset, t, exp);
                this.expr = this.convert(env, ctx, t, this.expr);
                this.field.setValue(this.expr);
                if (this.field.isConstant()) {
                    this.field.addModifiers(0x100000);
                }
                vset.addVar(this.field.number);
            } else if (declError) {
                vset.addVar(this.field.number);
            } else {
                vset.addVarUnassigned(this.field.number);
            }
            return vset;
        }
        env.error(e.where, "invalid.decl");
        return vset;
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        if (this.field.isInnerClass()) {
            ClassDefinition body = this.field.getInnerClass();
            body.inlineLocalClass(env);
            return null;
        }
        if (env.opt() && !this.field.isUsed()) {
            return new ExpressionStatement(this.where, this.expr).inline(env, ctx);
        }
        ctx.declare(env, this.field);
        if (this.expr != null) {
            this.expr = this.expr.inlineValue(env, ctx);
            this.field.setValue(this.expr);
            if (env.opt() && this.field.writecount == 0) {
                if (this.expr.op == 60) {
                    IdentifierExpression e = (IdentifierExpression)this.expr;
                    if (e.field.isLocal() && (ctx = ctx.getInlineContext()) != null && ((LocalMember)e.field).number < ctx.varNumber) {
                        this.field.setValue(this.expr);
                        this.field.addModifiers(0x100000);
                    }
                }
                if (this.expr.isConstant() || this.expr.op == 82 || this.expr.op == 83) {
                    this.field.setValue(this.expr);
                    this.field.addModifiers(0x100000);
                }
            }
        }
        return this;
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        VarDeclarationStatement s = (VarDeclarationStatement)this.clone();
        if (this.expr != null) {
            s.expr = this.expr.copyInline(ctx);
        }
        return s;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        if (this.field != null && this.field.isInnerClass()) {
            return thresh;
        }
        return this.expr != null ? this.expr.costInline(thresh, env, ctx) : 0;
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        if (this.expr != null && !this.expr.type.isType(11)) {
            ctx.declare(env, this.field);
            this.expr.codeValue(env, ctx, asm);
            asm.add(this.where, 54 + this.field.getType().getTypeCodeOffset(), new LocalVariable(this.field, this.field.number));
        } else {
            ctx.declare(env, this.field);
            if (this.expr != null) {
                this.expr.code(env, ctx, asm);
            }
        }
    }

    @Override
    public void print(PrintStream out, int indent) {
        out.print("local ");
        if (this.field != null) {
            out.print(this.field + "#" + this.field.hashCode());
            if (this.expr != null) {
                out.print(" = ");
                this.expr.print(out);
            }
        } else {
            this.expr.print(out);
            out.print(";");
        }
    }
}

