/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.impl.protocol.LocalClientRequestDispatcherBase;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.oa.OADestroyed;
import com.sun.corba.ee.spi.oa.OAInvocationInfo;
import com.sun.corba.ee.spi.oa.ObjectAdapter;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.protocol.ForwardException;
import com.sun.corba.ee.spi.trace.Subcontract;

@Subcontract
public abstract class ServantCacheLocalCRDBase
extends LocalClientRequestDispatcherBase {
    private OAInvocationInfo cachedInfo;

    protected ServantCacheLocalCRDBase(ORB orb, int scid, IOR ior) {
        super(orb, scid, ior);
    }

    @Override
    @Subcontract
    protected void cleanupAfterOADestroyed() {
        this.cachedInfo = null;
    }

    @Subcontract
    protected synchronized OAInvocationInfo getCachedInfo() throws OADestroyed {
        if (!this.servantIsLocal) {
            throw poaWrapper.servantMustBeLocal();
        }
        if (this.cachedInfo == null) {
            this.updateCachedInfo();
        }
        return this.cachedInfo;
    }

    @Subcontract
    private void updateCachedInfo() throws OADestroyed {
        ObjectAdapter oa = this.oaf.find(this.oaid);
        this.cachedInfo = oa.makeInvocationInfo(this.objectId);
        oa.enter();
        this.orb.pushInvocationInfo(this.cachedInfo);
        try {
            oa.getInvocationServant(this.cachedInfo);
        }
        catch (ForwardException freq) {
            throw poaWrapper.illegalForwardRequest(freq);
        }
        finally {
            oa.returnServant();
            oa.exit();
            this.orb.popInvocationInfo();
        }
    }
}

