/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ProducerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.CompositeData;

public class ProducerManagerMonitor
extends MQMBeanReadOnly {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanParameterInfo[] getProducerInfoByIDSignature;
    private static MBeanParameterInfo[] numWildcardProducersSignature;
    private static MBeanOperationInfo[] ops;

    public Integer getNumProducers() {
        return Producer.getNumProducers();
    }

    public Integer getNumWildcardProducers() throws MBeanException {
        return Producer.getNumWildcardProducers();
    }

    public Integer getNumWildcardProducers(String wildcard) throws MBeanException {
        int numWildcardProducers = Producer.getNumWildcardProducers();
        if (numWildcardProducers <= 0) {
            return 0;
        }
        Iterator producers = Producer.getWildcardProducers();
        if (producers == null) {
            return 0;
        }
        int count = 0;
        while (producers.hasNext()) {
            ProducerUID pid = (ProducerUID)producers.next();
            Producer oneProd = (Producer)Producer.getProducer(pid);
            if (wildcard != null) {
                DestinationUID id = oneProd.getDestinationUID();
                if (!id.getName().equals(wildcard)) continue;
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    public String[] getProducerWildcards() throws MBeanException {
        ArrayList<String> al = new ArrayList<String>();
        String[] list = null;
        int numWildcardProducers = Producer.getNumWildcardProducers();
        if (numWildcardProducers <= 0) {
            return null;
        }
        Iterator producers = Producer.getWildcardProducers();
        if (producers == null) {
            return null;
        }
        while (producers.hasNext()) {
            ProducerUID pid = (ProducerUID)producers.next();
            Producer oneProd = (Producer)Producer.getProducer(pid);
            DestinationUID id = oneProd.getDestinationUID();
            al.add(id.getName());
        }
        if (al.size() > 0) {
            list = new String[al.size()];
            list = al.toArray(list);
        }
        return list;
    }

    public String[] getProducerIDs() throws MBeanException {
        return ProducerUtil.getProducerIDs();
    }

    public CompositeData[] getProducerInfo() throws MBeanException {
        CompositeData[] cds = null;
        try {
            cds = ProducerUtil.getProducerInfo();
        }
        catch (Exception e) {
            this.handleOperationException("getProducerInfo", e);
        }
        return cds;
    }

    public CompositeData getProducerInfoByID(String producerID) throws MBeanException {
        CompositeData cd = null;
        try {
            cd = ProducerUtil.getProducerInfo(producerID);
        }
        catch (Exception e) {
            this.handleOperationException("getProducerInfoByID", e);
        }
        return cd;
    }

    @Override
    public String getMBeanName() {
        return "ProducerManagerMonitor";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1147");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[2];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("NumProducers", Integer.class.getName(), mbr.getString("MB1142"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("NumWildcardProducers", Integer.class.getName(), mbr.getString("MB1256"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray = new MBeanParameterInfo[1];
        mBeanParameterInfoArray[0] = new MBeanParameterInfo("producerID", String.class.getName(), mbr.getString("MB1146"));
        getProducerInfoByIDSignature = mBeanParameterInfoArray;
        MBeanParameterInfo[] mBeanParameterInfoArray2 = new MBeanParameterInfo[1];
        mBeanParameterInfoArray2[0] = new MBeanParameterInfo("wildcard", String.class.getName(), mbr.getString("MB1252"));
        numWildcardProducersSignature = mBeanParameterInfoArray2;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[5];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getProducerIDs", mbr.getString("MB1143"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getProducerInfo", mbr.getString("MB1144"), null, CompositeData[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getProducerInfoByID", mbr.getString("MB1145"), getProducerInfoByIDSignature, CompositeData.class.getName(), 0);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("getProducerWildcards", mbr.getString("MB1257"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[4] = new MBeanOperationInfo("getNumWildcardProducers", mbr.getString("MB1258"), numWildcardProducersSignature, Integer.class.getName(), 0);
        ops = mBeanOperationInfoArray;
    }
}

