/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp;

import com.sun.messaging.bridge.api.ByteBufferWrapper;
import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompFrameMessageFactory;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.LoggerWrapper;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.OutputStream;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.BufferOutputStream;

public class StompFrameMessageImpl
extends StompFrameMessage {
    private static final Logger logger = Globals.getLogger();
    private static final BrokerResources br = Globals.getBrokerResources();
    private static final StompFrameMessageFactory factory = new StompFrameMessageFactoryImpl();

    public static StompFrameMessageFactory getFactory() {
        return factory;
    }

    protected StompFrameMessageImpl(StompFrameMessage.Command cmd, LoggerWrapper logger) {
        super(cmd, logger);
    }

    public static StompFrameMessageImpl parseCommand(Buffer buf) throws Exception {
        return (StompFrameMessageImpl)StompFrameMessage.parseCommand(new ByteBufferWrapperImpl(buf), logger, factory);
    }

    public void parseHeader(Buffer buf, String protocolVersion) throws Exception {
        super.parseHeader(new ByteBufferWrapperImpl(buf), protocolVersion);
    }

    public void readBody(Buffer buf) throws Exception {
        super.readBody(new ByteBufferWrapperImpl(buf));
    }

    public void readNULL(Buffer buf) throws Exception {
        super.readNULL(new ByteBufferWrapperImpl(buf));
    }

    @Override
    protected OutputStream newBufferOutputStream(Object obj) throws IOException {
        MemoryManager mm = (MemoryManager)obj;
        return new BufferOutputStream(mm);
    }

    @Override
    protected ByteBufferWrapper getBuffer(OutputStream os) throws IOException {
        BufferOutputStream bos = (BufferOutputStream)os;
        return new ByteBufferWrapperImpl(bos.getBuffer());
    }

    @Override
    protected String getKStringX_CANNOT_PARSE_BODY_TO_TEXT(String cmd, String emsg) {
        return br.getKString("B4461", cmd, emsg);
    }

    @Override
    protected String getKStringX_HEADER_NOT_SPECIFIED_FOR(String headerName, String cmd) {
        return br.getKString("B4462", headerName, cmd);
    }

    @Override
    protected String getKStringX_INVALID_HEADER_VALUE(String headerValue, String cmd) {
        return br.getKString("B4463", headerValue, cmd);
    }

    @Override
    protected String getKStringX_INVALID_HEADER(String headerName) {
        return br.getKString("B4464", headerName);
    }

    @Override
    protected String getKStringX_MAX_HEADERS_EXCEEDED(int maxHeaders) {
        return br.getKString("B4465", maxHeaders);
    }

    @Override
    protected String getKStringX_EXCEPTION_PARSE_HEADER(String headerName, String emsg) {
        return br.getKString("B4466", headerName, emsg);
    }

    @Override
    protected String getKStringX_NO_NULL_TERMINATOR(String contentlen) {
        return br.getKString("B4467", contentlen);
    }

    @Override
    protected String getKStringX_UNKNOWN_STOMP_CMD(String cmd) {
        return br.getKString("B4468", cmd);
    }

    @Override
    protected String getKStringX_MAX_LINELEN_EXCEEDED(int maxbytes) {
        return br.getKString("B4469", maxbytes);
    }

    private static class ByteBufferWrapperImpl
    implements ByteBufferWrapper<Buffer> {
        private Buffer buf = null;

        ByteBufferWrapperImpl(Buffer buf) {
            this.buf = buf;
        }

        @Override
        public Buffer getWrapped() {
            return this.buf;
        }

        @Override
        public int position() {
            return this.buf.position();
        }

        @Override
        public ByteBufferWrapper position(int newPosition) {
            this.buf.position(newPosition);
            return this;
        }

        @Override
        public boolean hasRemaining() {
            return this.buf.hasRemaining();
        }

        @Override
        public int remaining() {
            return this.buf.remaining();
        }

        @Override
        public ByteBufferWrapper flip() {
            this.buf.flip();
            return this;
        }

        @Override
        public byte get() {
            return this.buf.get();
        }
    }

    static class StompFrameMessageFactoryImpl
    implements StompFrameMessageFactory {
        StompFrameMessageFactoryImpl() {
        }

        @Override
        public StompFrameMessage newStompFrameMessage(StompFrameMessage.Command cmd, LoggerWrapper logger) {
            return new StompFrameMessageImpl(cmd, logger);
        }
    }
}

