/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer.cfg;

import com.sun.enterprise.deployment.types.ConcurrencyContextType;
import java.io.Serializable;
import java.util.Set;
import org.glassfish.concurrent.config.ManagedExecutorService;
import org.glassfish.concurrent.runtime.deployer.cfg.CfgParser;
import org.glassfish.concurrent.runtime.deployer.cfg.ConcurrentServiceCfg;

public class ManagedExecutorServiceCfg
implements Serializable {
    private static final long serialVersionUID = 6798969542162777949L;
    private final ConcurrentServiceCfg serviceConfig;
    private final int hungAfterSeconds;
    private final boolean hungLoggerPrintOnce;
    private final long hungLoggerInitialDelaySeconds;
    private final long hungLoggerIntervalSeconds;
    private final boolean longRunningTasks;
    private final int threadPriority;
    private final int corePoolSize;
    private final long keepAliveSeconds;
    private final int maximumPoolSize;
    private final int taskQueueCapacity;
    private final long threadLifeTimeSeconds;

    public ManagedExecutorServiceCfg(ManagedExecutorService config) {
        Set<ConcurrencyContextType> propagated = CfgParser.parseContextInfo(config.getContextInfo(), config.getContextInfoEnabled());
        this.serviceConfig = new ConcurrentServiceCfg(config.getJndiName(), propagated, config.getContext());
        this.hungAfterSeconds = CfgParser.parseInt(config.getHungAfterSeconds(), 0);
        this.hungLoggerPrintOnce = Boolean.valueOf(config.getHungLoggerPrintOnce());
        this.hungLoggerInitialDelaySeconds = CfgParser.parseLong(config.getHungLoggerInitialDelaySeconds(), 60L);
        this.hungLoggerIntervalSeconds = CfgParser.parseLong(config.getHungLoggerIntervalSeconds(), 60L);
        this.longRunningTasks = Boolean.valueOf(config.getLongRunningTasks());
        this.threadPriority = CfgParser.parseInt(config.getThreadPriority(), 5);
        this.corePoolSize = CfgParser.parseInt(config.getCorePoolSize(), 0);
        this.keepAliveSeconds = CfgParser.parseLong(config.getKeepAliveSeconds(), 60L);
        this.maximumPoolSize = CfgParser.parseInt(config.getMaximumPoolSize(), Integer.MAX_VALUE);
        this.taskQueueCapacity = CfgParser.parseInt(config.getTaskQueueCapacity(), Integer.MAX_VALUE);
        this.threadLifeTimeSeconds = CfgParser.parseLong(config.getThreadLifetimeSeconds(), 0L);
    }

    public ConcurrentServiceCfg getServiceConfig() {
        return this.serviceConfig;
    }

    public int getHungAfterSeconds() {
        return this.hungAfterSeconds;
    }

    public boolean isHungLoggerPrintOnce() {
        return this.hungLoggerPrintOnce;
    }

    public long getHungLoggerInitialDelaySeconds() {
        return this.hungLoggerInitialDelaySeconds;
    }

    public long getHungLoggerIntervalSeconds() {
        return this.hungLoggerIntervalSeconds;
    }

    public boolean isLongRunningTasks() {
        return this.longRunningTasks;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public long getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getTaskQueueCapacity() {
        return this.taskQueueCapacity;
    }

    public long getThreadLifeTimeSeconds() {
        return this.threadLifeTimeSeconds;
    }
}

