/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.util.LinkedHashMap;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.jboss.jdeparser.AbstractJType;
import org.jboss.jdeparser.CachingThreadLocal;
import org.jboss.jdeparser.CharJExpr;
import org.jboss.jdeparser.DecimalDoubleJExpr;
import org.jboss.jdeparser.DecimalFloatJExpr;
import org.jboss.jdeparser.DirectJCall;
import org.jboss.jdeparser.HexDoubleJExpr;
import org.jboss.jdeparser.HexFloatJExpr;
import org.jboss.jdeparser.IntegerJExpr;
import org.jboss.jdeparser.JArrayExpr;
import org.jboss.jdeparser.JAssignableExpr;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JLambda;
import org.jboss.jdeparser.JLambdaImpl;
import org.jboss.jdeparser.JParamDeclaration;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.jdeparser.LongJExpr;
import org.jboss.jdeparser.NameJExpr;
import org.jboss.jdeparser.PlainJArrayExpr;
import org.jboss.jdeparser.StaticJCall;
import org.jboss.jdeparser.StringJExpr;

public final class JExprs {
    static final ThreadLocal<LinkedHashMap<String, JAssignableExpr>> cache = new CachingThreadLocal<String, JAssignableExpr>();

    private JExprs() {
    }

    public static JExpr decimal(int val) {
        return new IntegerJExpr(val, 10);
    }

    public static JExpr decimal(long val) {
        return new LongJExpr(val, 10);
    }

    public static JExpr decimal(float val) {
        return new DecimalFloatJExpr(val);
    }

    public static JExpr decimal(double val) {
        return new DecimalDoubleJExpr(val);
    }

    public static JExpr hex(int val) {
        return new IntegerJExpr(val, 16);
    }

    public static JExpr hex(long val) {
        return new LongJExpr(val, 16);
    }

    public static JExpr hex(float val) {
        return new HexFloatJExpr(val);
    }

    public static JExpr hex(double val) {
        return new HexDoubleJExpr(val);
    }

    public static JExpr binary(int val) {
        return new IntegerJExpr(val, 2);
    }

    public static JExpr binary(long val) {
        return new LongJExpr(val, 2);
    }

    public static JExpr str(String string) {
        return new StringJExpr(string);
    }

    public static JExpr ch(int val) {
        return new CharJExpr(val);
    }

    public static JCall call(ExecutableElement element) {
        ElementKind kind = element.getKind();
        if (kind == ElementKind.METHOD) {
            String name = element.getSimpleName().toString();
            return JExprs.call(name);
        }
        throw new IllegalArgumentException("Unsupported element for call: " + element);
    }

    public static JCall call(String name) {
        return new DirectJCall(name);
    }

    public static JCall callStatic(String type, String name) {
        return JExprs.callStatic(JTypes.typeNamed(type), name);
    }

    public static JCall callStatic(JType type, String name) {
        return new StaticJCall(AbstractJType.of(type), name);
    }

    public static JCall callStatic(Class<?> type, String name) {
        return JExprs.callStatic(JTypes.typeOf(type), name);
    }

    public static JAssignableExpr $v(String name) {
        return JExprs.name(name);
    }

    public static JAssignableExpr $v(JParamDeclaration paramDeclaration) {
        return JExprs.name(paramDeclaration.name());
    }

    public static JAssignableExpr $v(JVarDeclaration varDeclaration) {
        return JExprs.name(varDeclaration.name());
    }

    public static JAssignableExpr name(String name) {
        LinkedHashMap<String, JAssignableExpr> map = cache.get();
        JAssignableExpr ret = map.get(name);
        if (ret == null) {
            ret = new NameJExpr(name);
            map.put(name, ret);
        }
        return ret;
    }

    public static JAssignableExpr name(JParamDeclaration paramDeclaration) {
        return JExprs.name(paramDeclaration.name());
    }

    public static JAssignableExpr name(JVarDeclaration varDeclaration) {
        return JExprs.name(varDeclaration.name());
    }

    public static JArrayExpr array() {
        return new PlainJArrayExpr();
    }

    public static JArrayExpr array(JExpr ... members) {
        return new PlainJArrayExpr(members);
    }

    public static JArrayExpr array(String ... members) {
        JExpr[] exprs = new JExpr[members.length];
        for (int i = 0; i < members.length; ++i) {
            exprs[i] = JExprs.str(members[i]);
        }
        return new PlainJArrayExpr(exprs);
    }

    public static JArrayExpr array(int ... members) {
        JExpr[] exprs = new JExpr[members.length];
        for (int i = 0; i < members.length; ++i) {
            exprs[i] = JExprs.decimal(members[i]);
        }
        return new PlainJArrayExpr(exprs);
    }

    public static JArrayExpr array(long ... members) {
        JExpr[] exprs = new JExpr[members.length];
        for (int i = 0; i < members.length; ++i) {
            exprs[i] = JExprs.decimal(members[i]);
        }
        return new PlainJArrayExpr(exprs);
    }

    public static JLambda lambda() {
        return new JLambdaImpl();
    }
}

