/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import jakarta.ws.rs.QueryParam;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import org.glassfish.jersey.microprofile.restclient.ParamModel;

class QueryParamModel
extends ParamModel<Map<String, Object[]>> {
    private final String queryParamName;

    QueryParamModel(ParamModel.Builder builder, QueryParam annotation) {
        super(builder);
        this.queryParamName = annotation.value();
    }

    @Override
    public Map<String, Object[]> handleParameter(Map<String, Object[]> requestPart, Class<? extends Annotation> annotationClass, Object instance) {
        Object resolvedValue = this.interfaceModel.resolveParamValue(instance, this.parameter);
        if (resolvedValue instanceof Object[]) {
            requestPart.put(this.queryParamName, (Object[])resolvedValue);
        } else if (resolvedValue instanceof Collection) {
            requestPart.put(this.queryParamName, ((Collection)resolvedValue).toArray());
        } else {
            requestPart.put(this.queryParamName, new Object[]{resolvedValue});
        }
        return requestPart;
    }

    @Override
    public boolean handles(Class<? extends Annotation> annotation) {
        return QueryParam.class.equals(annotation);
    }
}

