/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAMonitorService;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import java.util.Hashtable;

public class QuiesceHandler
extends AdminCmdHandler {
    private static boolean DEBUG = QuiesceHandler.getDEBUG();

    public QuiesceHandler(AdminDataHandler parent) {
        super(parent);
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": Quiescing broker: " + String.valueOf(cmd_props));
        }
        int status = 200;
        String errMsg = null;
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        HAMonitorService hamonitor = Globals.getHAMonitorService();
        if (hamonitor != null && hamonitor.inTakeover()) {
            status = 500;
            errMsg = this.rb.getString("B3233");
            this.logger.log(32, this.getClass().getName() + ": " + errMsg);
        } else {
            try {
                BrokerStateHandler bsh = Globals.getBrokerStateHandler();
                bsh.quiesce();
            }
            catch (Exception ex) {
                errMsg = ex.toString();
                status = 500;
            }
        }
        QuiesceHandler.setProperties(reply, 75, status, errMsg);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

