/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sequencing;

import java.util.Map;
import java.util.Queue;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.persistence.internal.sequencing.SequencingLogInOut;

class PreallocationHandler
implements SequencingLogInOut {
    protected Map<String, Queue<Object>> preallocatedSequences;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Queue<Object> getPreallocated(String sequenceName) {
        Queue<Object> sequences = this.preallocatedSequences.get(sequenceName);
        if (sequences == null) {
            Map<String, Queue<Object>> map = this.preallocatedSequences;
            synchronized (map) {
                sequences = this.preallocatedSequences.get(sequenceName);
                if (sequences == null) {
                    sequences = new ConcurrentLinkedQueue<Object>();
                    this.preallocatedSequences.put(sequenceName, sequences);
                }
            }
        }
        return sequences;
    }

    @Override
    public void onConnect() {
        this.initializePreallocated();
    }

    @Override
    public void onDisconnect() {
        this.preallocatedSequences = null;
    }

    @Override
    public boolean isConnected() {
        return this.preallocatedSequences != null;
    }

    public void initializePreallocated() {
        this.preallocatedSequences = new ConcurrentHashMap<String, Queue<Object>>(20);
    }

    public void initializePreallocated(String seqName) {
        this.preallocatedSequences.remove(seqName);
    }

    public void setPreallocated(String seqName, Vector<?> sequences) {
        this.getPreallocated(seqName).addAll(sequences);
    }
}

