/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.Immediate;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.internal.HandleAndService;
import org.glassfish.hk2.internal.ImmediateLocalLocatorFilter;
import org.glassfish.hk2.utilities.ImmediateErrorHandler;

@Singleton
@Visibility(value=DescriptorVisibility.LOCAL)
public class ImmediateContext
implements Context<Immediate> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final HashMap<ActiveDescriptor<?>, HandleAndService> currentImmediateServices = new HashMap();
    private final HashMap<ActiveDescriptor<?>, Long> creating = new HashMap();
    private final ServiceLocator locator;
    private final Filter validationFilter;

    @Inject
    private ImmediateContext(ServiceLocator locator) {
        this.locator = locator;
        this.validationFilter = new ImmediateLocalLocatorFilter(locator.getLocatorId());
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Immediate.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        U retVal = null;
        this.lock.lock();
        try {
            HandleAndService has = this.currentImmediateServices.get(activeDescriptor);
            if (has != null) {
                Object object = has.getService();
                return (U)object;
            }
            while (this.creating.containsKey(activeDescriptor)) {
                long alreadyCreatingThread = this.creating.get(activeDescriptor);
                if (alreadyCreatingThread == Thread.currentThread().getId()) {
                    throw new MultiException(new IllegalStateException("A circular dependency involving Immediate service " + activeDescriptor.getImplementation() + " was found.  Full descriptor is " + activeDescriptor));
                }
                try {
                    this.notEmpty.await();
                }
                catch (InterruptedException ie) {
                    throw new MultiException(ie);
                }
            }
            has = this.currentImmediateServices.get(activeDescriptor);
            if (has != null) {
                Object object = has.getService();
                return (U)object;
            }
            this.creating.put(activeDescriptor, Thread.currentThread().getId());
        }
        finally {
            this.lock.unlock();
        }
        try {
            retVal = activeDescriptor.create(root);
        }
        finally {
            this.lock.lock();
            try {
                ServiceHandle<?> discoveredRoot = null;
                if (root != null && root.getActiveDescriptor().equals(activeDescriptor)) {
                    discoveredRoot = root;
                }
                if (retVal != null) {
                    this.currentImmediateServices.put(activeDescriptor, new HandleAndService(discoveredRoot, retVal));
                }
                this.creating.remove(activeDescriptor);
                this.notEmpty.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
        return retVal;
    }

    @Override
    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        this.lock.lock();
        try {
            boolean bl = this.currentImmediateServices.containsKey(descriptor);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void destroyOne(ActiveDescriptor<?> descriptor) {
        this.destroyOne(descriptor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyOne(ActiveDescriptor<?> descriptor, List<ImmediateErrorHandler> errorHandlers) {
        if (errorHandlers == null) {
            errorHandlers = this.locator.getAllServices(ImmediateErrorHandler.class, new Annotation[0]);
        }
        this.lock.lock();
        try {
            HandleAndService has = this.currentImmediateServices.remove(descriptor);
            Object instance = has.getService();
            try {
                descriptor.dispose(instance);
            }
            catch (Throwable th) {
                for (ImmediateErrorHandler ieh : errorHandlers) {
                    try {
                        ieh.preDestroyFailed(descriptor, th);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean supportsNullCreation() {
        return false;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        List<ImmediateErrorHandler> errorHandlers = this.locator.getAllServices(ImmediateErrorHandler.class, new Annotation[0]);
        this.lock.lock();
        try {
            for (Map.Entry<ActiveDescriptor<?>, HandleAndService> entry : new HashSet(this.currentImmediateServices.entrySet())) {
                HandleAndService has = entry.getValue();
                ServiceHandle<?> handle = has.getHandle();
                if (handle != null) {
                    handle.destroy();
                    continue;
                }
                this.destroyOne(entry.getKey(), errorHandlers);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private List<ActiveDescriptor<?>> getImmediateServices() {
        List<ActiveDescriptor<?>> inScopeAndInThisLocator;
        try {
            inScopeAndInThisLocator = this.locator.getDescriptors(this.validationFilter);
        }
        catch (IllegalStateException ise) {
            inScopeAndInThisLocator = Collections.emptyList();
        }
        return inScopeAndInThisLocator;
    }

    public Filter getValidationFilter() {
        return this.validationFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() {
        List<ImmediateErrorHandler> errorHandlers;
        List<ActiveDescriptor<?>> inScopeAndInThisLocator = this.getImmediateServices();
        try {
            errorHandlers = this.locator.getAllServices(ImmediateErrorHandler.class, new Annotation[0]);
        }
        catch (IllegalStateException ise) {
            return;
        }
        LinkedHashSet newFullSet = new LinkedHashSet(inScopeAndInThisLocator);
        LinkedHashSet addMe = new LinkedHashSet();
        this.lock.lock();
        try {
            while (this.creating.size() > 0) {
                try {
                    this.notEmpty.await();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
            }
            LinkedHashSet oldSet = new LinkedHashSet(this.currentImmediateServices.keySet());
            for (ActiveDescriptor<?> activeDescriptor : inScopeAndInThisLocator) {
                if (oldSet.contains(activeDescriptor)) continue;
                addMe.add(activeDescriptor);
            }
            oldSet.removeAll(newFullSet);
            for (ActiveDescriptor<Object> activeDescriptor : oldSet) {
                HandleAndService has = this.currentImmediateServices.get(activeDescriptor);
                ServiceHandle<?> handle = has.getHandle();
                if (handle != null) {
                    handle.destroy();
                    continue;
                }
                this.destroyOne(activeDescriptor, errorHandlers);
            }
        }
        finally {
            this.lock.unlock();
        }
        for (ActiveDescriptor<Object> activeDescriptor : addMe) {
            try {
                this.locator.getServiceHandle(activeDescriptor).getService();
            }
            catch (Throwable th) {
                for (ImmediateErrorHandler ieh : errorHandlers) {
                    try {
                        ieh.postConstructFailed(activeDescriptor, th);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    }
}

