/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.interceptors.CallbackChainImpl;
import com.sun.ejb.containers.interceptors.InterceptorUtil;
import com.sun.enterprise.container.common.spi.util.InterceptorInfo;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class CallbackInvocationContext
implements InvocationContext {
    private Map<String, Object> contextData;
    private int callbackIndex = 0;
    private CallbackChainImpl callbackChain;
    private Object[] interceptorInstances;
    private Object targetObjectInstance;
    private LifecycleCallbackDescriptor.CallbackType eventType;
    Method method;
    private Class<?> targetObjectClass;
    private Constructor<?> ctor;
    private Class<?>[] ctorParamTypes;
    private Object[] ctorParams;
    private BaseContainer container;
    private EJBContextImpl ctx;
    private InterceptorInfo interceptorInfo;

    public CallbackInvocationContext(Object targetObjectInstance, Object[] interceptorInstances, CallbackChainImpl chain) {
        this.targetObjectInstance = targetObjectInstance;
        this.interceptorInstances = interceptorInstances;
        this.callbackChain = chain;
    }

    public CallbackInvocationContext(Object targetObjectInstance, Object[] interceptorInstances, CallbackChainImpl chain, LifecycleCallbackDescriptor.CallbackType eventType) {
        this(targetObjectInstance, interceptorInstances, chain);
        this.eventType = eventType;
    }

    public CallbackInvocationContext(Class<?> targetObjectClass, Object[] interceptorInstances, CallbackChainImpl chain, LifecycleCallbackDescriptor.CallbackType eventType, InterceptorInfo interceptorInfo) {
        this(null, interceptorInstances, chain, eventType);
        Constructor<?>[] ctors;
        this.targetObjectClass = targetObjectClass;
        for (Constructor<?> ctor0 : ctors = targetObjectClass.getConstructors()) {
            this.ctor = ctor0;
            if (ctor0.getParameterTypes().length == 0) break;
        }
        this.ctorParamTypes = this.ctor.getParameterTypes();
        this.ctorParams = new Object[this.ctorParamTypes.length];
        this.interceptorInfo = interceptorInfo;
    }

    public CallbackInvocationContext(Class<?> targetObjectClass, Object[] interceptorInstances, CallbackChainImpl chain, LifecycleCallbackDescriptor.CallbackType eventType, BaseContainer container, EJBContextImpl ctx) {
        this(targetObjectClass, interceptorInstances, chain, eventType, null);
        this.container = container;
        this.ctx = ctx;
    }

    public Object getTarget() {
        return this.targetObjectInstance;
    }

    public Object[] getInterceptorInstances() {
        return this.interceptorInstances;
    }

    public Object getTimer() {
        return null;
    }

    public Constructor<?> getConstructor() {
        if (this.eventType == LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT) {
            return this.ctor;
        }
        return null;
    }

    public Method getMethod() {
        if (this.eventType == LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT) {
            return null;
        }
        return this.method;
    }

    public Object[] getParameters() {
        if (this.eventType == LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT) {
            return this.ctorParams;
        }
        throw new IllegalStateException("not applicable to Callback methods");
    }

    public void setParameters(Object[] params) {
        if (this.eventType != LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT) {
            throw new IllegalStateException("not applicable to Callback methods");
        }
        this.checkSetParameters(params);
        this.ctorParams = params;
    }

    public Map<String, Object> getContextData() {
        if (this.contextData == null) {
            this.contextData = new HashMap<String, Object>();
        }
        return this.contextData;
    }

    public Object proceed() throws Exception {
        try {
            ++this.callbackIndex;
            return this.callbackChain.invokeNext(this.callbackIndex, this);
        }
        catch (Exception ex) {
            throw ex;
        }
        catch (Throwable th) {
            throw new Exception(th);
        }
    }

    public void invokeSpecial() throws Throwable {
        if (this.eventType == LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT) {
            if (this.container == null) {
                this.targetObjectInstance = this.targetObjectClass.newInstance();
                this.interceptorInfo.setTargetObjectInstance(this.targetObjectInstance);
            } else {
                this.container.createEjbInstanceForInterceptors(this.ctorParams, this.ctx);
                this.targetObjectInstance = this.ctx.getEJB();
            }
        }
    }

    private void checkSetParameters(Object[] params) {
        if (this.ctor == null) {
            throw new IllegalStateException("Internal Error: Got null constructor");
        }
        if (params == null && this.ctorParamTypes.length != 0) {
            throw new IllegalArgumentException("Wrong number of parameters for  constructor: " + String.valueOf(this.ctor));
        }
        if (params != null && this.ctorParamTypes.length != params.length) {
            throw new IllegalArgumentException("Wrong number of parameters for  constructor: " + String.valueOf(this.ctor));
        }
        int index = 0;
        for (Class<?> type : this.ctorParamTypes) {
            if (params[index] == null) {
                if (type.isPrimitive()) {
                    throw new IllegalArgumentException("Parameter type mismatch for constructor " + String.valueOf(this.ctor) + ".  Attempt to set a null value for Arg[" + index + "]. Expected a value of type: " + type.getName());
                }
            } else if (type.isPrimitive()) {
                if (!InterceptorUtil.hasCompatiblePrimitiveWrapper(type, params[index].getClass())) {
                    throw new IllegalArgumentException("Parameter type mismatch for constructor " + String.valueOf(this.ctor) + ".  Arg[" + index + "] type: " + params[index].getClass().getName() + " is not compatible with the expected type: " + type.getName());
                }
            } else if (!type.isAssignableFrom(params[index].getClass())) {
                throw new IllegalArgumentException("Parameter type mismatch for constructor " + String.valueOf(this.ctor) + ".  Arg[" + index + "] type: " + params[index].getClass().getName() + " does not match the expected type: " + type.getName());
            }
            ++index;
        }
    }
}

