/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool.resizer;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceState;
import com.sun.enterprise.resource.allocator.ResourceAllocator;
import com.sun.enterprise.resource.pool.PoolProperties;
import com.sun.enterprise.resource.pool.ResourceHandler;
import com.sun.enterprise.resource.pool.datastructure.DataStructure;
import jakarta.resource.spi.ManagedConnection;
import java.util.HashSet;
import java.util.Set;
import java.util.TimerTask;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class Resizer
extends TimerTask {
    private static final System.Logger LOG = System.getLogger(Resizer.class.getName());
    protected PoolInfo poolInfo;
    protected DataStructure dataStructure;
    protected PoolProperties pool;
    protected ResourceHandler handler;
    protected boolean preferValidateOverRecreate;

    public Resizer(PoolInfo poolInfo, DataStructure ds, PoolProperties pp, ResourceHandler handler, boolean preferValidateOverRecreate) {
        this.poolInfo = poolInfo;
        this.dataStructure = ds;
        this.pool = pp;
        this.handler = handler;
        this.preferValidateOverRecreate = preferValidateOverRecreate;
    }

    @Override
    public void run() {
        LOG.log(System.Logger.Level.DEBUG, () -> "Resizing the pool " + String.valueOf(this.poolInfo));
        try {
            this.resizePool(true);
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, "Resizing the pool failed for pool: " + String.valueOf(this.poolInfo), (Throwable)e);
        }
    }

    public void resizePool(boolean forced) {
        if (this.pool.getWaitQueueLength() > 0) {
            return;
        }
        int noOfResourcesRemoved = this.removeIdleAndInvalidResources();
        int poolScaleDownQuantity = this.pool.getResizeQuantity() - noOfResourcesRemoved;
        this.scaleDownPool(poolScaleDownQuantity, forced);
        this.ensureSteadyPool();
        LOG.log(System.Logger.Level.DEBUG, "No. of resources held for pool {0}: ", this.poolInfo, this.dataStructure.getResourcesSize());
    }

    private void ensureSteadyPool() {
        if (this.dataStructure.getResourcesSize() < this.pool.getSteadyPoolSize()) {
            for (int i = this.dataStructure.getResourcesSize(); i < this.pool.getSteadyPoolSize(); ++i) {
                try {
                    this.handler.createResourceAndAddToPool();
                    continue;
                }
                catch (PoolingException e) {
                    LOG.log(System.Logger.Level.WARNING, "Steady pool size could not be ensured for pool: " + String.valueOf(this.poolInfo), (Throwable)e);
                }
            }
        }
    }

    protected void scaleDownPool(int scaleDownQuantity, boolean forced) {
        if (this.pool.getResizeQuantity() > 0 && forced) {
            ResourceHandle h;
            int n = scaleDownQuantity = scaleDownQuantity <= this.dataStructure.getResourcesSize() - this.pool.getSteadyPoolSize() ? scaleDownQuantity : 0;
            while (scaleDownQuantity > 0 && (h = this.dataStructure.getResource()) != null) {
                this.dataStructure.removeResource(h);
                --scaleDownQuantity;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int removeIdleAndInvalidResources() {
        int poolSizeBeforeRemoval = this.dataStructure.getResourcesSize();
        int size = this.dataStructure.getFreeListSize();
        long currentTime = System.currentTimeMillis();
        int validConnectionsCounter = 0;
        int idleConnKeptInSteadyCounter = 0;
        HashSet<ResourceHandle> activeResources = new HashSet<ResourceHandle>();
        HashSet<String> resourcesToValidate = new HashSet<String>();
        try {
            ResourceHandle h;
            while ((h = this.dataStructure.getResource()) != null) {
                ResourceState state = h.getResourceState();
                if (currentTime - state.getLastUsage() < this.pool.getIdleTimeout()) {
                    ++validConnectionsCounter;
                    resourcesToValidate.add(h.toString());
                    activeResources.add(h);
                    continue;
                }
                boolean isResourceEligibleForRemoval = this.isResourceEligibleForRemoval(h, validConnectionsCounter);
                if (!isResourceEligibleForRemoval) {
                    ++idleConnKeptInSteadyCounter;
                    activeResources.add(h);
                    LOG.log(System.Logger.Level.DEBUG, "PreferValidateOverRecreate: Keeping idle resource {0} in the steady part of the free pool as the RA reports it to be valid ({1} <= {2})", h, ++validConnectionsCounter, this.pool.getSteadyPoolSize());
                    continue;
                }
                this.dataStructure.removeResource(h);
            }
        }
        finally {
            for (ResourceHandle activeResource : activeResources) {
                this.dataStructure.returnResource(activeResource);
            }
        }
        this.removeInvalidResources(resourcesToValidate);
        if (this.preferValidateOverRecreate) {
            LOG.log(System.Logger.Level.DEBUG, "Idle resources validated and kept in the steady pool {0}: {1}", this.poolInfo, idleConnKeptInSteadyCounter);
            LOG.log(System.Logger.Level.DEBUG, "Number of Idle resources freed from pool {0}: {1}", this.poolInfo, size - activeResources.size() - idleConnKeptInSteadyCounter);
            LOG.log(System.Logger.Level.DEBUG, "Number of Invalid resources removed from pool {0}: {1}", this.poolInfo, activeResources.size() - this.dataStructure.getFreeListSize() + idleConnKeptInSteadyCounter);
        } else {
            LOG.log(System.Logger.Level.DEBUG, "Number of Idle resources freed from pool {0}: {1}", this.poolInfo, size - activeResources.size());
            LOG.log(System.Logger.Level.DEBUG, "Number of Invalid resources removed from pool {0}: {1}", this.poolInfo, activeResources.size() - this.dataStructure.getFreeListSize());
        }
        return poolSizeBeforeRemoval - this.dataStructure.getResourcesSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInvalidResources(Set<String> freeConnectionsToValidate) {
        try {
            LOG.log(System.Logger.Level.DEBUG, "Sending a set of free connections to RA, of size: {0}", freeConnectionsToValidate.size());
            int invalidConnectionsCount = 0;
            HashSet<ResourceHandle> validResources = new HashSet<ResourceHandle>();
            try {
                ResourceHandle handle;
                while ((handle = this.dataStructure.getResource()) != null) {
                    if (freeConnectionsToValidate.contains(handle.toString())) {
                        HashSet<ManagedConnection> connectionsToTest = new HashSet<ManagedConnection>();
                        connectionsToTest.add(handle.getResource());
                        Set<ManagedConnection> invalidConnections = this.handler.getInvalidConnections(connectionsToTest);
                        if (invalidConnections != null && !invalidConnections.isEmpty()) {
                            invalidConnectionsCount = this.validateAndRemoveResource(handle, invalidConnections);
                            continue;
                        }
                        validResources.add(handle);
                        continue;
                    }
                    validResources.add(handle);
                }
            }
            catch (Throwable throwable) {
                for (ResourceHandle resourceHandle : validResources) {
                    this.dataStructure.returnResource(resourceHandle);
                }
                validResources.clear();
                LOG.log(System.Logger.Level.DEBUG, "No. of invalid resources received from RA: {0}", invalidConnectionsCount);
                throw throwable;
            }
            for (ResourceHandle resourceHandle : validResources) {
                this.dataStructure.returnResource(resourceHandle);
            }
            validResources.clear();
            LOG.log(System.Logger.Level.DEBUG, "No. of invalid resources received from RA: {0}", invalidConnectionsCount);
        }
        catch (Exception re) {
            LOG.log(System.Logger.Level.WARNING, "Removing invalid resources from the pool " + String.valueOf(this.poolInfo) + " failed!", (Throwable)re);
        }
    }

    protected int validateAndRemoveResource(ResourceHandle handle, Set<ManagedConnection> invalidConnections) {
        int invalidConnectionsCount = 0;
        for (ManagedConnection invalid : invalidConnections) {
            if (!invalid.equals(handle.getResource())) continue;
            this.dataStructure.removeResource(handle);
            this.handler.invalidConnectionDetected(handle);
            ++invalidConnectionsCount;
        }
        return invalidConnectionsCount;
    }

    protected boolean isResourceEligibleForRemoval(ResourceHandle handle, int validConnectionsCounter) {
        ResourceAllocator allocator = handle.getResourceAllocator();
        if (!this.preferValidateOverRecreate || !allocator.hasValidatingMCF()) {
            return true;
        }
        if (validConnectionsCounter < this.pool.getSteadyPoolSize() && allocator.isConnectionValid(handle)) {
            handle.getResourceState().setLastValidated(System.currentTimeMillis());
            return false;
        }
        if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
            if (validConnectionsCounter <= this.pool.getSteadyPoolSize()) {
                LOG.log(System.Logger.Level.DEBUG, "PreferValidateOverRecreate: Removing idle resource " + String.valueOf(handle) + " from the free pool as the RA reports it to be invalid");
            } else {
                LOG.log(System.Logger.Level.DEBUG, "PreferValidateOverRecreate: Removing idle resource " + String.valueOf(handle) + " from the free pool as the steady part size has already been exceeded (" + validConnectionsCounter + " > " + this.pool.getSteadyPoolSize() + ")");
            }
        }
        return true;
    }
}

