/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.AdminCommandJob;
import com.sun.enterprise.v3.admin.AsyncAdminCommandInvoker;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.codehaus.jettison.json.JSONException;
import org.glassfish.admin.rest.OptionsCapable;
import org.glassfish.admin.rest.composite.CompositeUtil;
import org.glassfish.admin.rest.composite.metadata.RestResourceMetadata;
import org.glassfish.admin.rest.provider.MethodMetaData;
import org.glassfish.admin.rest.resources.AbstractResource;
import org.glassfish.admin.rest.resources.CommandResult;
import org.glassfish.admin.rest.results.ActionReportResult;
import org.glassfish.admin.rest.results.OptionsResult;
import org.glassfish.admin.rest.utils.DetachedSseAdminCommandInvoker;
import org.glassfish.admin.rest.utils.ResourceUtil;
import org.glassfish.admin.rest.utils.SseAdminCommandInvoker;
import org.glassfish.admin.rest.utils.Util;
import org.glassfish.admin.rest.utils.xml.RestActionReporter;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandInvocation;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.internal.api.Globals;

public class TemplateExecCommand
extends AbstractResource
implements OptionsCapable {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TemplateExecCommand.class);
    protected String resourceName;
    protected String commandName;
    protected String commandDisplayName;
    protected String commandMethod;
    protected String commandAction;
    protected boolean isLinkedToParent = false;

    public TemplateExecCommand(String resourceName, String commandName, String commandMethod, String commandAction, String commandDisplayName, boolean isLinkedToParent) {
        this.resourceName = resourceName;
        this.commandName = commandName;
        this.commandMethod = commandMethod;
        this.commandAction = commandAction;
        this.commandDisplayName = commandDisplayName;
        this.isLinkedToParent = isLinkedToParent;
    }

    @Override
    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    @Override
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    @OPTIONS
    @Produces(value={"application/json", "text/html", "application/xml"})
    public ActionReportResult optionsLegacyFormat() {
        RestActionReporter ar = new RestActionReporter();
        ar.setExtraProperties(new Properties());
        ar.setActionDescription(this.commandDisplayName);
        OptionsResult optionsResult = new OptionsResult(this.resourceName);
        HashMap<String, MethodMetaData> mmd = new HashMap<String, MethodMetaData>();
        MethodMetaData methodMetaData = ResourceUtil.getMethodMetaData(this.commandName, this.getCommandParams(), this.locatorBridge.getRemoteLocator());
        optionsResult.putMethodMetaData(this.commandMethod, methodMetaData);
        mmd.put(this.commandMethod, methodMetaData);
        ResourceUtil.addMethodMetaData((ActionReport)ar, mmd);
        ActionReportResult ret = new ActionReportResult(ar, null, optionsResult);
        ret.setCommandDisplayName(this.commandDisplayName);
        return ret;
    }

    @OPTIONS
    @Produces(value={"application/vnd.oracle.glassfish+json;qs=0.5"})
    public String options() throws JSONException {
        try {
            return new RestResourceMetadata(this).toJson().toString(Util.getFormattingIndentLevel());
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected final Response executeSseCommand(ParameterMap params) {
        boolean notify = params == null ? false : params.containsKey((Object)"notify");
        boolean detach = params == null ? false : params.containsKey((Object)"detach");
        CommandRunner commandRunner = (CommandRunner)Globals.getDefaultHabitat().getService(CommandRunner.class, new Annotation[0]);
        CommandInvocation invocation = commandRunner.getCommandInvocation(null, this.commandName, (ActionReport)new RestActionReporter(), null, notify, detach).parameters(params);
        Response.ResponseBuilder builder = Response.status((int)200);
        AsyncAdminCommandInvoker invoker = detach ? new DetachedSseAdminCommandInvoker((CommandInvocation<AdminCommandJob>)invocation, builder) : new SseAdminCommandInvoker((CommandInvocation<AdminCommandJob>)invocation, builder);
        return (Response)invoker.start();
    }

    protected Response executeCommandLegacyFormat(ParameterMap data) {
        RestActionReporter actionReport = ResourceUtil.runCommand(this.commandName, data, this.getSubject());
        ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
        int status = exitCode == ActionReport.ExitCode.FAILURE ? 500 : 200;
        ActionReportResult option = this.optionsLegacyFormat();
        ActionReportResult results = new ActionReportResult(this.commandName, actionReport, option.getMetaData());
        results.getActionReport().getExtraProperties().putAll((Map<?, ?>)option.getActionReport().getExtraProperties());
        results.setCommandDisplayName(this.commandDisplayName);
        return Response.status((int)status).entity((Object)results).build();
    }

    protected CommandResult executeCommand(ParameterMap data) {
        RestActionReporter actionReport = ResourceUtil.runCommand(this.commandName, data, this.getSubject());
        ActionReport.ExitCode exitCode = actionReport.getActionExitCode();
        if (exitCode == ActionReport.ExitCode.FAILURE) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)actionReport.getMessage()).build());
        }
        CommandResult cr = CompositeUtil.instance().getModel(CommandResult.class);
        cr.setMessage(actionReport.getMessage());
        cr.setProperties(actionReport.getTopMessagePart().getProps());
        cr.setExtraProperties(this.getExtraProperties(actionReport));
        return cr;
    }

    private Map<String, Object> getExtraProperties(RestActionReporter actionReport) {
        Properties props = actionReport.getExtraProperties();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            map.put(entry.getKey().toString(), entry.getValue());
        }
        return map;
    }

    protected HashMap<String, String> getCommandParams() {
        return null;
    }

    protected void processCommandParams(ParameterMap data) {
        HashMap<String, String> commandParams = this.getCommandParams();
        if (commandParams != null) {
            ResourceUtil.resolveParamValues(commandParams, this.uriInfo);
            for (Map.Entry<String, String> entry : commandParams.entrySet()) {
                data.add((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
    }

    protected void addQueryString(MultivaluedMap<String, String> qs, ParameterMap data) {
        for (Map.Entry entry : qs.entrySet()) {
            String key = (String)entry.getKey();
            for (String value : (List)entry.getValue()) {
                try {
                    data.add((Object)key, (Object)URLDecoder.decode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }

    protected void adjustParameters(ParameterMap data) {
        if (data != null) {
            boolean isRenamed;
            if (!data.containsKey((Object)"DEFAULT") && !(isRenamed = this.renameParameter(data, "name", "DEFAULT"))) {
                this.renameParameter(data, "id", "DEFAULT");
            }
            data.remove((Object)"jsoncallback");
            data.remove((Object)"_");
        }
    }

    protected boolean renameParameter(ParameterMap data, String parameterToRename, String newName) {
        if (data.containsKey((Object)parameterToRename)) {
            List value = data.get((Object)parameterToRename);
            data.remove((Object)parameterToRename);
            data.set((Object)newName, (Collection)value);
            return true;
        }
        return false;
    }

    protected void purgeEmptyEntries(ParameterMap data) {
        HashSet<String> keyToRemove = new HashSet<String>();
        Set entries = data.entrySet();
        for (Object entry : entries) {
            if (entry.getValue() != null && !((List)entry.getValue()).isEmpty()) continue;
            keyToRemove.add((String)entry.getKey());
        }
        if ("true".equals(data.getOne((Object)"__remove_empty_entries__"))) {
            data.remove((Object)"__remove_empty_entries__");
            Set entries2 = data.entrySet();
            for (Map.Entry entry : entries2) {
                if (((List)entry.getValue()).size() != 1 || !((String)((List)entry.getValue()).get(0)).equals("")) continue;
                keyToRemove.add((String)entry.getKey());
            }
        }
        for (String k : keyToRemove) {
            data.remove((Object)k);
        }
    }

    protected String getParent(UriInfo uriInfo) {
        List segments = uriInfo.getPathSegments(true);
        String parent = ((PathSegment)segments.get(segments.size() - 2)).getPath();
        return parent;
    }
}

