/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.common;

import com.sun.enterprise.v3.common.ActionReporter;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.glassfish.api.ActionReport;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Service(name="xml")
@PerLookup
public class XMLActionReporter
extends ActionReporter {
    public void writeReport(OutputStream os) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document d = db.newDocument();
            d.appendChild(this.writeActionReport(d, this));
            this.writeXML(d, os);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Element writeActionReport(Document owningDocument, ActionReporter report) {
        Element result = owningDocument.createElement("action-report");
        result.setAttribute("description", report.getActionDescription());
        result.setAttribute("exit-code", report.getActionExitCode().name());
        if (this.getFailureCause() != null) {
            result.setAttribute("failure-cause", this.getFailureCause().getLocalizedMessage());
        }
        this.writePart(result, report.getTopMessagePart(), null);
        for (ActionReporter subReport : report.getSubActionsReport()) {
            result.appendChild(this.writeActionReport(owningDocument, subReport));
        }
        return result;
    }

    @Override
    public String getContentType() {
        return "application/xml";
    }

    private void writePart(Element actionReport, ActionReport.MessagePart part, String childType) {
        Document d = actionReport.getOwnerDocument();
        Element messagePart = d.createElement("message-part");
        actionReport.appendChild(messagePart);
        if (childType != null) {
            messagePart.setAttribute("type", childType);
        }
        for (Map.Entry<Object, Object> prop : part.getProps().entrySet()) {
            Element p = d.createElement("property");
            messagePart.appendChild(p);
            p.setAttribute("name", prop.getKey().toString());
            Object value = prop.getValue();
            if (value instanceof List) {
                this.addListElement(p, (List)value);
                continue;
            }
            if (value instanceof Map) {
                this.addMapElement(p, (Map)value);
                continue;
            }
            p.setAttribute("value", prop.getValue().toString());
        }
        messagePart.setAttribute("message", part.getMessage());
        for (ActionReport.MessagePart subPart : part.getChildren()) {
            this.writePart(messagePart, subPart, subPart.getChildrenType());
        }
    }

    private void addListElement(Element parent, List list) {
        Document d = parent.getOwnerDocument();
        Element listElement = d.createElement("list");
        parent.appendChild(listElement);
        for (Object entry : list) {
            Element entryElement = d.createElement("entry");
            listElement.appendChild(entryElement);
            if (entry instanceof List) {
                this.addListElement(entryElement, (List)entry);
                continue;
            }
            if (entry instanceof Map) {
                this.addMapElement(entryElement, (Map)entry);
                continue;
            }
            entryElement.setAttribute("value", entry.toString());
        }
    }

    private void addMapElement(Element parent, Map map) {
        Document d = parent.getOwnerDocument();
        Element mapElement = d.createElement("map");
        parent.appendChild(mapElement);
        for (Map.Entry entry : map.entrySet()) {
            Element entryElement = d.createElement("entry");
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            mapElement.appendChild(entryElement);
            entryElement.setAttribute("key", key);
            if (value instanceof List) {
                this.addListElement(entryElement, (List)value);
                continue;
            }
            if (value instanceof Map) {
                this.addMapElement(entryElement, (Map)value);
                continue;
            }
            entryElement.setAttribute("value", value.toString());
        }
    }

    private void writeXML(Document doc, OutputStream os) throws TransformerConfigurationException, TransformerException {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(os);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "utf-8");
        transformer.transform(source, result);
    }
}

