/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.Property;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.util.List;

public final class PropertyRenderer
extends Renderer {
    public boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        boolean overlapLabel;
        String labelAlign;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        Property property = (Property)component;
        Theme theme = ThemeUtilities.getTheme(context);
        writer.startElement("tr", (UIComponent)property);
        writer.writeAttribute("id", (Object)property.getClientId(context), null);
        String propValue = RenderingUtilities.getStyleClasses(context, component, null);
        if (propValue != null) {
            writer.writeAttribute("class", (Object)propValue, null);
        }
        if ((propValue = property.getStyle()) != null) {
            writer.writeAttribute("style", (Object)propValue, "style");
        }
        writer.startElement("td", (UIComponent)property);
        writer.writeAttribute("valign", (Object)"top", null);
        boolean nowrap = property.isNoWrap();
        if (nowrap) {
            writer.writeAttribute("nowrap", (Object)"nowrap", null);
        }
        if ((labelAlign = property.getLabelAlign()) != null) {
            writer.writeAttribute("align", (Object)labelAlign, null);
        }
        if (overlapLabel = property.isOverlapLabel()) {
            writer.writeAttribute("colspan", (Object)"2", null);
        }
        writer.startElement("div", (UIComponent)property);
        writer.writeAttribute("class", (Object)theme.getStyleClass("CONTENT_TABLE_COL1_DIV"), null);
        this.renderLabel(context, property, theme, writer);
        if (!overlapLabel) {
            writer.endElement("div");
            writer.endElement("td");
            writer.startElement("td", (UIComponent)property);
            writer.startElement("div", (UIComponent)property);
            writer.writeAttribute("class", (Object)theme.getStyleClass("CONTENT_TABLE_COL2_DIV"), null);
        }
        this.renderPropertyComponents(context, property, theme, writer);
        this.renderHelpText(context, property, theme, writer);
        writer.endElement("div");
        writer.endElement("td");
        writer.endElement("tr");
    }

    protected void renderPropertyComponents(FacesContext context, Property property, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent content = property.getContentComponent();
        if (content != null) {
            RenderingUtilities.renderComponent(content, context);
            return;
        }
        List children = property.getChildren();
        for (Object child : children) {
            RenderingUtilities.renderComponent((UIComponent)child, context);
        }
    }

    protected void renderLabel(FacesContext context, Property property, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent label = property.getLabelComponent();
        if (label != null) {
            RenderingUtilities.renderComponent(label, context);
            return;
        }
        writer.startElement("span", (UIComponent)property);
        writer.writeAttribute("class", (Object)theme.getStyleClass("LABEL_LEVEL_TWO_TEXT"), null);
        writer.write("&nbsp;");
        writer.endElement("span");
    }

    protected void renderHelpText(FacesContext context, Property property, Theme theme, ResponseWriter writer) throws IOException {
        UIComponent helpText = property.getHelpTextComponent();
        if (helpText != null) {
            RenderingUtilities.renderComponent(helpText, context);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
    }
}

