/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.data.provider.RowKey;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableColumn;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class TableRowGroupRenderer
extends Renderer {
    private static final String[] STRING_ATTRIBUTES = new String[]{"align", "bgColor", "char", "charOff", "dir", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseUp", "onMouseMove", "onMouseOut", "onMouseOver", "style", "valign"};

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            TableRowGroupRenderer.log("encodeBegin", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            TableRowGroupRenderer.log("encodeBegin", "Component not rendered, nothing to display");
            return;
        }
        TableRowGroup group = (TableRowGroup)component;
        ResponseWriter writer = context.getResponseWriter();
        if (group.isAboveColumnHeader()) {
            this.renderGroupHeader(context, group, writer);
            this.renderColumnHeaders(context, group, writer);
        } else {
            this.renderColumnHeaders(context, group, writer);
            this.renderGroupHeader(context, group, writer);
        }
        group.setRowKey(null);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            TableRowGroupRenderer.log("encodeChildren", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            TableRowGroupRenderer.log("encodeChildren", "Component not rendered, nothing to display");
            return;
        }
        TableRowGroup group = (TableRowGroup)component;
        ResponseWriter writer = context.getResponseWriter();
        if (group.getRowCount() == 0) {
            TableRowGroupRenderer.log("encodeChildren", "Cannot render data, row count is zero");
            this.renderEmptyDataColumn(context, group, writer);
            return;
        }
        RowKey[] rowKeys = group.getRenderedRowKeys();
        if (rowKeys == null) {
            TableRowGroupRenderer.log("encodeChildren", "Cannot render data, RowKey array is null");
            return;
        }
        for (int i = 0; i < rowKeys.length; ++i) {
            group.setRowKey(rowKeys[i]);
            if (!group.isRowAvailable()) {
                TableRowGroupRenderer.log("encodeChildren", "Cannot render data, row not available");
                break;
            }
            this.renderEnclosingTagStart(context, group, writer, i);
            Iterator<TableColumn> kids = group.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumn col = kids.next();
                if (!col.isRendered()) {
                    TableRowGroupRenderer.log("encodeChildren", "TableColumn not rendered, nothing to display");
                    continue;
                }
                RenderingUtilities.renderComponent((UIComponent)col, context);
            }
            this.renderEnclosingTagEnd(writer);
        }
        group.setRowKey(null);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            TableRowGroupRenderer.log("encodeEnd", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            TableRowGroupRenderer.log("encodeEnd", "Component not rendered, nothing to display");
            return;
        }
        TableRowGroup group = (TableRowGroup)component;
        ResponseWriter writer = context.getResponseWriter();
        if (group.getRowCount() == 0) {
            TableRowGroupRenderer.log("encodeEnd", "Column, group, and table footers not rendered, row count is zero");
            return;
        }
        if (group.isAboveColumnFooter()) {
            this.renderGroupFooter(context, group, writer);
            this.renderColumnFooters(context, group, writer);
        } else {
            this.renderColumnFooters(context, group, writer);
            this.renderGroupFooter(context, group, writer);
        }
        Table table = group.getTableAncestor();
        if (table.getRowCount() > 0) {
            this.renderTableColumnFooters(context, group, writer);
        } else {
            TableRowGroupRenderer.log("encodeEnd", "Table column footers not rendered, row count is zero");
        }
        group.setRowKey(null);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderEmptyDataColumn(FacesContext context, TableRowGroup component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableRowGroupRenderer.log("renderEmptyDataColumn", "Cannot render empty data column, TableRowGroup is null");
            return;
        }
        this.renderEnclosingTagStart(context, component, writer, -1);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(component.getEmptyDataColumn(), context);
        this.renderEnclosingTagEnd(writer);
    }

    protected void renderColumnFooters(FacesContext context, TableRowGroup component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableRowGroupRenderer.log("renderColumnFooters", "Cannot render column footers, TableRowGroup is null");
            return;
        }
        Map map = this.getColumnFooterMap(component);
        Theme theme = this.getTheme();
        Table table = component.getTableAncestor();
        for (int c = 0; c < map.size(); ++c) {
            if (c > 0 && !component.isMultipleColumnFooters()) {
                TableRowGroupRenderer.log("renderColumnFooters", "Multiple column footers not rendered, nothing to display");
                break;
            }
            boolean renderStartElement = true;
            List list = (List)map.get(c);
            for (int i = 0; i < list.size(); ++i) {
                TableColumn col = (TableColumn)((Object)list.get(i));
                if (!col.isRendered()) {
                    TableRowGroupRenderer.log("renderColumnFooters", "TableColumn not rendered, nothing to display");
                    continue;
                }
                UIComponent footer = col.getColumnFooter();
                if (footer == null || !footer.isRendered()) {
                    TableRowGroupRenderer.log("renderColumnFooters", "Column footer not rendered, nothing to display");
                    continue;
                }
                if (renderStartElement) {
                    renderStartElement = false;
                    writer.writeText((Object)"\n", null);
                    writer.startElement("tr", (UIComponent)component);
                    writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_columnFooterBar" + UINamingContainer.getSeparatorChar((FacesContext)context) + c), null);
                    if (component.isCollapsed()) {
                        writer.writeAttribute("class", (Object)theme.getStyleClass("HIDDEN"), null);
                    }
                }
                RenderingUtilities.renderComponent(footer, context);
            }
            if (renderStartElement) continue;
            writer.endElement("tr");
        }
    }

    protected void renderColumnHeaders(FacesContext context, TableRowGroup component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableRowGroupRenderer.log("renderColumnHeaders", "Cannot render column headers, TableRowGroup is null");
            return;
        }
        Map<Integer, List<TableColumn>> map = this.getColumnHeaderMap(component);
        Theme theme = this.getTheme();
        Table table = component.getTableAncestor();
        for (int c = 0; c < map.size(); ++c) {
            boolean renderStartElement = true;
            List<TableColumn> list = map.get(c);
            for (int i = 0; i < list.size(); ++i) {
                TableColumn col = list.get(i);
                if (!col.isRendered()) {
                    TableRowGroupRenderer.log("renderColumnHeaders", "TableColumn not rendered, nothing to display");
                    continue;
                }
                UIComponent header = col.getColumnHeader();
                if (header == null || !header.isRendered()) {
                    TableRowGroupRenderer.log("renderColumnHeaders", "Column header not rendered, nothing to display");
                    continue;
                }
                if (renderStartElement) {
                    renderStartElement = false;
                    writer.writeText((Object)"\n", null);
                    writer.startElement("tr", (UIComponent)component);
                    writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_columnHeaderBar" + UINamingContainer.getSeparatorChar((FacesContext)context) + c), null);
                    if (component.isCollapsed() && table != null && table.getColumnHeadersCount() > 1) {
                        writer.writeAttribute("class", (Object)theme.getStyleClass("HIDDEN"), null);
                    }
                }
                RenderingUtilities.renderComponent(header, context);
            }
            if (renderStartElement) continue;
            writer.endElement("tr");
        }
    }

    protected void renderTableColumnFooters(FacesContext context, TableRowGroup component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableRowGroupRenderer.log("renderTableColumnFooters", "Cannot render table column footers, TableRowGroup is null");
            return;
        }
        Map map = this.getColumnFooterMap(component);
        Theme theme = this.getTheme();
        Table table = component.getTableAncestor();
        for (int c = 0; c < map.size(); ++c) {
            if (c > 0 && table != null && !component.isMultipleTableColumnFooters()) {
                TableRowGroupRenderer.log("renderTableColumnFooters", "Multiple table column footers not rendered, nothing to display");
                break;
            }
            boolean renderStartElement = true;
            List list = (List)map.get(c);
            for (int i = 0; i < list.size(); ++i) {
                TableColumn col = (TableColumn)((Object)list.get(i));
                if (!col.isRendered()) {
                    TableRowGroupRenderer.log("renderTableColumnFooters", "TableColumn not rendered, nothing to display");
                    continue;
                }
                UIComponent footer = col.getTableColumnFooter();
                if (footer == null || !footer.isRendered()) {
                    TableRowGroupRenderer.log("renderTableColumnFooters", "Table column footer not rendered, nothing to display");
                    continue;
                }
                if (renderStartElement) {
                    renderStartElement = false;
                    writer.writeText((Object)"\n", null);
                    writer.startElement("tr", (UIComponent)component);
                    writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_tableColumnFooterBar" + UINamingContainer.getSeparatorChar((FacesContext)context) + c), null);
                    if (component.isCollapsed() && table.getColumnHeadersCount() > 1) {
                        writer.writeAttribute("class", (Object)theme.getStyleClass("HIDDEN"), null);
                    }
                }
                RenderingUtilities.renderComponent(footer, context);
            }
            if (renderStartElement) continue;
            writer.endElement("tr");
        }
    }

    protected void renderGroupFooter(FacesContext context, TableRowGroup component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableRowGroupRenderer.log("renderGroupFooter", "Cannot render group footer, TableRowGroup is null");
            return;
        }
        UIComponent footer = component.getGroupFooter();
        if (footer == null || !footer.isRendered()) {
            TableRowGroupRenderer.log("renderGroupFooter", "Group footer not rendered, nothing to display");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_groupFooterBar"), null);
        if (component.isCollapsed()) {
            writer.writeAttribute("class", (Object)theme.getStyleClass("HIDDEN"), null);
        }
        RenderingUtilities.renderComponent(footer, context);
        writer.endElement("tr");
    }

    protected void renderGroupHeader(FacesContext context, TableRowGroup component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableRowGroupRenderer.log("renderGroupHeader", "Cannot render group header, TableRowGroup is null");
            return;
        }
        UIComponent header = component.getGroupHeader();
        if (header == null || !header.isRendered()) {
            TableRowGroupRenderer.log("renderGroupHeader", "Group header not rendered, nothing to display");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_groupHeaderBar"), null);
        RenderingUtilities.renderComponent(header, context);
        writer.endElement("tr");
    }

    protected void renderEnclosingTagStart(FacesContext context, TableRowGroup component, ResponseWriter writer, int index) throws IOException {
        String s;
        if (component == null) {
            TableRowGroupRenderer.log("renderEnclosingTagStart", "Cannot render enclosing tag, TableRowGroup is null");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        String[] styleClasses = this.getRowStyleClasses(component);
        Object styleClass = index > -1 && styleClasses.length > 0 ? styleClasses[index % styleClasses.length] : null;
        if (component.isSelected()) {
            s = theme.getStyleClass("TABLE_SELECT_ROW");
            styleClass = styleClass != null ? (String)styleClass + " " + s : s;
        }
        if (component.isCollapsed()) {
            s = theme.getStyleClass("HIDDEN");
            styleClass = styleClass != null ? (String)styleClass + " " + s : s;
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)component, (String)styleClass);
        if (component.getToolTip() != null) {
            writer.writeAttribute("title", (Object)component.getToolTip(), "toolTip");
        }
        RenderingUtilities.writeStringAttributes((UIComponent)component, writer, STRING_ATTRIBUTES);
    }

    protected void renderEnclosingTagEnd(ResponseWriter writer) throws IOException {
        writer.endElement("tr");
    }

    private Map getColumnFooterMap(TableRowGroup component) {
        Map<Integer, List<TableColumn>> map = this.getColumnHeaderMap(component);
        if (map.isEmpty()) {
            TableRowGroupRenderer.log("getColumnFooterMap", "Cannot obtain column footer map");
            return map;
        }
        HashMap<Integer, List<TableColumn>> newMap = new HashMap<Integer, List<TableColumn>>();
        for (int i = 0; i < map.size(); ++i) {
            newMap.put(i, map.get(map.size() - i - 1));
        }
        List newList = (List)newMap.get(0);
        for (int c = 1; c < newMap.size(); ++c) {
            List list = (List)newMap.get(c);
            for (int i = list.size() - 1; i >= 0; --i) {
                TableColumn col = (TableColumn)((Object)list.get(i));
                if (col.getTableColumnChildren().hasNext()) continue;
                int colspan = 0;
                for (int k = i - 1; k >= 0; --k) {
                    TableColumn prevCol = (TableColumn)((Object)list.get(k));
                    if (!prevCol.getTableColumnChildren().hasNext()) continue;
                    colspan += prevCol.getColumnCount();
                }
                newList.add(colspan, col);
                list.remove(i);
            }
        }
        return newMap;
    }

    private Map<Integer, List<TableColumn>> getColumnHeaderMap(TableRowGroup component) {
        HashMap<Integer, List<TableColumn>> map = new HashMap<Integer, List<TableColumn>>();
        if (component == null) {
            TableRowGroupRenderer.log("getColumnHeaderMap", "Cannot obtain column header map, TableRowGroup is null");
            return map;
        }
        Iterator<TableColumn> kids = component.getTableColumnChildren();
        while (kids.hasNext()) {
            TableColumn col = kids.next();
            this.initColumnHeaderMap(col, map, 0);
        }
        return map;
    }

    private String getId(UIComponent component, String id) {
        FacesContext context = FacesContext.getCurrentInstance();
        String clientId = component.getClientId(context);
        return clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + id;
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private String[] getRowStyleClasses(TableRowGroup component) {
        String values = component != null ? component.getStyleClasses() : null;
        if (values == null) {
            return new String[0];
        }
        values = values.trim();
        ArrayList<String> list = new ArrayList<String>();
        while (values.length() > 0) {
            int comma = values.indexOf(",");
            if (comma >= 0) {
                list.add(values.substring(0, comma).trim());
                values = values.substring(comma + 1);
                continue;
            }
            list.add(values.trim());
            values = "";
        }
        String[] results = new String[list.size()];
        return list.toArray(results);
    }

    private void initColumnHeaderMap(TableColumn component, Map<Integer, List<TableColumn>> map, int level) {
        List<TableColumn> list;
        if (component == null) {
            TableRowGroupRenderer.log("initColumnHeaderMap", "Cannot initialize column header map, TableColumn is null");
            return;
        }
        Iterator<TableColumn> kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                TableColumn col = kids.next();
                if (!col.isRendered()) continue;
                this.initColumnHeaderMap(col, map, level + 1);
            }
        }
        if ((list = map.get(level)) == null) {
            list = new ArrayList<TableColumn>();
        }
        list.add(component);
        map.put(level, list);
    }

    private static void log(String method, String msg) {
        Class<TableRowGroupRenderer> clazz = TableRowGroupRenderer.class;
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + msg);
        }
    }
}

