/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.jwt.eesecurity;

import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.omnifaces.jwt.eesecurity.SignedJWTCredential;
import org.omnifaces.jwt.eesecurity.SignedJWTIdentityStore;

public class JWTAuthenticationMechanism
implements HttpAuthenticationMechanism {
    public static final String CONFIG_TOKEN_HEADER_AUTHORIZATION = "Authorization";
    public static final String CONFIG_TOKEN_HEADER_COOKIE = "Cookie";
    private final String configJwtTokenHeader;
    private final String configJwtTokenCookie;

    public JWTAuthenticationMechanism() {
        Optional<Properties> properties = SignedJWTIdentityStore.readVendorProperties();
        Config config = ConfigProvider.getConfig();
        this.configJwtTokenHeader = SignedJWTIdentityStore.readConfig("mp.jwt.token.header", properties, config, CONFIG_TOKEN_HEADER_AUTHORIZATION);
        if (!CONFIG_TOKEN_HEADER_AUTHORIZATION.equals(this.configJwtTokenHeader) && !CONFIG_TOKEN_HEADER_COOKIE.equals(this.configJwtTokenHeader)) {
            throw new DeploymentException("Configuration mp.jwt.token.header must be either Authorization or Cookie, but is " + this.configJwtTokenHeader);
        }
        this.configJwtTokenCookie = SignedJWTIdentityStore.readConfig("mp.jwt.token.cookie", properties, config, "Bearer");
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        IdentityStoreHandler identityStoreHandler = (IdentityStoreHandler)CDI.current().select(IdentityStoreHandler.class, new Annotation[0]).get();
        SignedJWTCredential credential = this.getCredential(request);
        if (credential != null) {
            CredentialValidationResult result = identityStoreHandler.validate((Credential)credential);
            if (result.getStatus() == CredentialValidationResult.Status.VALID) {
                httpMessageContext.getClientSubject().getPrincipals().add((Principal)result.getCallerPrincipal());
                return httpMessageContext.notifyContainerAboutLogin(result);
            }
            return httpMessageContext.responseUnauthorized();
        }
        return httpMessageContext.doNothing();
    }

    private SignedJWTCredential getCredential(HttpServletRequest request) {
        Optional<String> token = Optional.empty();
        if (CONFIG_TOKEN_HEADER_AUTHORIZATION.equals(this.configJwtTokenHeader)) {
            String authorizationHeader = request.getHeader(CONFIG_TOKEN_HEADER_AUTHORIZATION);
            if (authorizationHeader != null && authorizationHeader.startsWith("Bearer ")) {
                token = Optional.of(authorizationHeader.substring("Bearer ".length()));
            }
        } else {
            String bearerMark = ";" + this.configJwtTokenCookie + "=";
            String cookieHeader = request.getHeader(CONFIG_TOKEN_HEADER_COOKIE);
            if (cookieHeader != null && cookieHeader.startsWith("$Version=") && cookieHeader.contains(bearerMark)) {
                token = Optional.of(cookieHeader.substring(cookieHeader.indexOf(bearerMark) + bearerMark.length()));
            }
        }
        return token.map(t -> this.createSignedJWTCredential((String)t)).orElse(null);
    }

    private SignedJWTCredential createSignedJWTCredential(String token) {
        if (token != null && !token.isEmpty()) {
            return new SignedJWTCredential(token);
        }
        return null;
    }
}

