/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl.helper;

import org.apache.felix.cm.impl.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class TargetedPID {
    private final String rawPid;
    private final String servicePid;
    private final String symbolicName;
    private final String version;
    private final String location;
    private final short bindingLevel;

    public TargetedPID(String rawPid) {
        this.rawPid = rawPid;
        if (rawPid.indexOf(124) < 0) {
            this.servicePid = rawPid;
            this.symbolicName = null;
            this.version = null;
            this.location = null;
            this.bindingLevel = 0;
        } else {
            int start = 0;
            int end = rawPid.indexOf(124);
            this.servicePid = rawPid.substring(start, end);
            start = end + 1;
            if ((end = rawPid.indexOf(124, start)) >= 0) {
                this.symbolicName = rawPid.substring(start, end);
                start = end + 1;
                if ((end = rawPid.indexOf(124, start)) >= 0) {
                    this.version = rawPid.substring(start, end);
                    this.location = rawPid.substring(end + 1);
                    this.bindingLevel = (short)3;
                } else {
                    this.version = rawPid.substring(start);
                    this.location = null;
                    this.bindingLevel = (short)2;
                }
            } else {
                this.symbolicName = rawPid.substring(start);
                this.version = null;
                this.location = null;
                this.bindingLevel = 1;
            }
        }
    }

    public boolean matchesTarget(ServiceReference<?> reference) {
        Bundle serviceBundle = reference.getBundle();
        if (serviceBundle == null) {
            return false;
        }
        if (this.symbolicName == null) {
            return true;
        }
        if (!this.symbolicName.equals(serviceBundle.getSymbolicName())) {
            return false;
        }
        if (this.version == null) {
            return true;
        }
        if (!this.version.equals(serviceBundle.getVersion().toString())) {
            return false;
        }
        return this.location == null || this.location.equals(Activator.getLocation(serviceBundle));
    }

    public String getRawPid() {
        return this.rawPid;
    }

    public String getServicePid() {
        return this.servicePid;
    }

    boolean bindsStronger(TargetedPID other) {
        return this.bindingLevel > other.bindingLevel;
    }

    public int hashCode() {
        return this.rawPid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.getClass() == obj.getClass()) {
            return this.rawPid.equals(((TargetedPID)obj).rawPid);
        }
        return false;
    }

    public String toString() {
        return this.rawPid;
    }
}

