/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.forms;

import jakarta.annotation.Priority;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.mvc.form.FormMethodOverwriter;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.PreMatching;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.krazo.KrazoConfig;
import org.eclipse.krazo.security.FormEntityProvider;
import org.eclipse.krazo.util.ServiceLoaders;

@Provider
@PreMatching
@Priority(value=3000)
@RequestScoped
public class FormMethodOverwriteFilter
implements ContainerRequestFilter {
    private final FormEntityProvider formEntityProvider = ServiceLoaders.list(FormEntityProvider.class).get(0);
    @Inject
    private KrazoConfig krazoConfig;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Form form;
        String hiddenMethod;
        if (this.isFormMethodOverwriteEnabled() && this.isFormData(requestContext) && (hiddenMethod = this.getHiddenMethod(form = this.formEntityProvider.getForm(requestContext))) != null && !hiddenMethod.isEmpty()) {
            requestContext.setMethod(hiddenMethod);
        }
    }

    private boolean isFormMethodOverwriteEnabled() {
        return this.krazoConfig.getFormMethodOverwriteOption() == FormMethodOverwriter.Options.ENABLED;
    }

    private boolean isFormData(ContainerRequestContext requestContext) {
        return requestContext.getMethod().equals("POST") && MediaType.APPLICATION_FORM_URLENCODED_TYPE.isCompatible(requestContext.getMediaType());
    }

    private String getHiddenMethod(Form form) {
        String hiddenMethod = null;
        List hiddenFieldValues = (List)form.asMap().getOrDefault((Object)this.krazoConfig.getFormMethodOverwriteField(), Collections.emptyList());
        if (!hiddenFieldValues.isEmpty()) {
            hiddenMethod = (String)hiddenFieldValues.get(0);
        }
        return hiddenMethod;
    }
}

