/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.config;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.grizzly.config.SecurePasswordProvider;
import org.glassfish.grizzly.config.Utils;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.grizzly.config.ssl.SSLContextFactory;
import org.glassfish.grizzly.config.ssl.SSLImplementation;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.hk2.api.ServiceLocator;

public class SSLConfigurator
extends SSLEngineConfigurator {
    private static final String PLAIN_PASSWORD_PROVIDER_NAME = "plain";
    private static final System.Logger LOG = System.getLogger(SSLConfigurator.class.getName());
    private final Ssl ssl;
    private final ServiceLocator serviceLocator;

    public SSLConfigurator(ServiceLocator serviceLocator, Ssl ssl) {
        this.ssl = ssl;
        this.serviceLocator = serviceLocator;
        if (SSLConfigurator.isWantClientAuth(ssl)) {
            this.setWantClientAuth(true);
        }
        if (SSLConfigurator.isNeedClientAuth(ssl)) {
            this.setNeedClientAuth(true);
        }
        this.clientMode = false;
        this.sslContextConfiguration = new InternalSSLContextConfigurator();
    }

    private SSLImplementation getSslImplementation() {
        SSLImplementation implementation = (SSLImplementation)this.serviceLocator.getService(SSLImplementation.class, new Annotation[0]);
        if (implementation != null) {
            LOG.log(System.Logger.Level.DEBUG, () -> "Found SSL implementation: " + String.valueOf(implementation));
            return implementation;
        }
        String classname = this.ssl.getClassname() == null ? "com.sun.enterprise.security.ssl.GlassfishSSLImpl" : this.ssl.getClassname();
        LOG.log(System.Logger.Level.DEBUG, () -> "Creating SSL implementation: " + classname);
        try {
            return (SSLImplementation)Class.forName(classname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to create SSL implementation: " + classname, e);
        }
    }

    private SSLContext configureSSL() {
        try {
            SSLContext newSslContext = this.initializeSSLContext();
            if (this.ssl != null) {
                List<String> enabledProtocols = this.getListOfEnabledProtocols();
                if (enabledProtocols.isEmpty()) {
                    this.logEmptyWarning(this.ssl, "protocol variants");
                } else {
                    this.setEnabledProtocols((String[])enabledProtocols.toArray(String[]::new));
                }
                Set<String> ciphers = this.getSetOfEnabledCiphers();
                if (ciphers.isEmpty()) {
                    this.logEmptyWarning(this.ssl, "cipher suites");
                } else {
                    this.setEnabledCipherSuites((String[])ciphers.toArray(String[]::new));
                }
            }
            if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                LOG.log(System.Logger.Level.DEBUG, "Enabled secure protocols={0} and ciphers={1}", Arrays.toString(this.getEnabledProtocols()), Arrays.toString(this.getEnabledCipherSuites()));
            }
            return newSslContext;
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_GENERAL_CONFIG_ERROR(), (Throwable)e);
            return null;
        }
    }

    private SSLContext initializeSSLContext() {
        try {
            SSLContextFactory sslContextFactory = this.getSslImplementation().getSSLContextFactory();
            if (this.ssl != null) {
                if (this.ssl.getCrlFile() != null) {
                    SSLConfigurator.setAttribute(sslContextFactory, "crlFile", this.ssl.getCrlFile(), null, null);
                }
                if (this.ssl.getTrustAlgorithm() != null) {
                    SSLConfigurator.setAttribute(sslContextFactory, "truststoreAlgorithm", this.ssl.getTrustAlgorithm(), null, null);
                }
                if (this.ssl.getKeyAlgorithm() != null) {
                    SSLConfigurator.setAttribute(sslContextFactory, "algorithm", this.ssl.getKeyAlgorithm(), null, null);
                }
                SSLConfigurator.setAttribute(sslContextFactory, "trustMaxCertLength", this.ssl.getTrustMaxCertLength(), null, null);
            }
            SSLConfigurator.setAttribute(sslContextFactory, "keystore", this.ssl == null ? null : this.ssl.getKeyStore(), GlassFishVariable.KEYSTORE_FILE.getSystemPropertyName(), null);
            SSLConfigurator.setAttribute(sslContextFactory, "keystoreType", this.ssl == null ? null : this.ssl.getKeyStoreType(), GlassFishVariable.KEYSTORE_TYPE.getSystemPropertyName(), "PKCS12");
            SSLConfigurator.setAttribute(sslContextFactory, "keystorePass", this.ssl == null ? null : this.getKeyStorePassword(this.ssl), GlassFishVariable.KEYSTORE_PASSWORD.getSystemPropertyName(), "changeit");
            SSLConfigurator.setAttribute(sslContextFactory, "truststore", this.ssl == null ? null : this.ssl.getTrustStore(), GlassFishVariable.TRUSTSTORE_FILE.getSystemPropertyName(), null);
            SSLConfigurator.setAttribute(sslContextFactory, "truststoreType", this.ssl == null ? null : this.ssl.getTrustStoreType(), GlassFishVariable.TRUSTSTORE_TYPE.getSystemPropertyName(), "PKCS12");
            SSLConfigurator.setAttribute(sslContextFactory, "truststorePass", this.ssl == null ? null : this.getTrustStorePassword(this.ssl), GlassFishVariable.TRUSTSTORE_PASSWORD.getSystemPropertyName(), "changeit");
            sslContextFactory.setAttribute("keyAlias", this.ssl == null ? null : this.ssl.getCertNickname());
            SSLContext newSslContext = sslContextFactory.create();
            CipherInfo.updateCiphers(newSslContext);
            return newSslContext;
        }
        catch (IOException e) {
            LOG.log(System.Logger.Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_GENERAL_CONFIG_ERROR(), (Throwable)e);
            return null;
        }
    }

    private List<String> getListOfEnabledProtocols() {
        ArrayList<String> enabledProtocols = new ArrayList<String>(8);
        if (Boolean.parseBoolean(this.ssl.getSsl2Enabled())) {
            enabledProtocols.add("SSLv2");
        }
        if (Boolean.parseBoolean(this.ssl.getSsl3Enabled())) {
            enabledProtocols.add("SSLv3");
        }
        if (Boolean.parseBoolean(this.ssl.getTlsEnabled())) {
            enabledProtocols.add("TLSv1");
        }
        if (Boolean.parseBoolean(this.ssl.getTls11Enabled())) {
            enabledProtocols.add("TLSv1.1");
        }
        if (Boolean.parseBoolean(this.ssl.getTls12Enabled())) {
            enabledProtocols.add("TLSv1.2");
        }
        if (Boolean.parseBoolean(this.ssl.getTls13Enabled())) {
            enabledProtocols.add("TLSv1.3");
        }
        if (Boolean.parseBoolean(this.ssl.getSsl3Enabled()) || Boolean.parseBoolean(this.ssl.getTlsEnabled())) {
            enabledProtocols.add("SSLv2Hello");
        }
        return enabledProtocols;
    }

    private Set<String> getSetOfEnabledCiphers() {
        String ssl2Ciphers;
        LinkedList<String> enabledCiphers = new LinkedList<String>();
        String ssl3Ciphers = this.ssl.getSsl3TlsCiphers();
        if (ssl3Ciphers != null && ssl3Ciphers.length() > 0) {
            String[] ssl3CiphersArray;
            for (String cipher : ssl3CiphersArray = ssl3Ciphers.split(",")) {
                enabledCiphers.add(cipher.trim());
            }
        }
        if ((ssl2Ciphers = this.ssl.getSsl2Ciphers()) != null && ssl2Ciphers.length() > 0) {
            String[] ssl2CiphersArray;
            for (String cipher : ssl2CiphersArray = ssl2Ciphers.split(",")) {
                enabledCiphers.add(cipher.trim());
            }
        }
        return SSLConfigurator.getJSSECiphers(enabledCiphers);
    }

    protected void logEmptyWarning(Ssl ssl, String type) {
        if (!LOG.isLoggable(System.Logger.Level.WARNING)) {
            return;
        }
        StringBuilder name = new StringBuilder();
        for (NetworkListener listener : ((Protocol)ssl.getParent()).findNetworkListeners()) {
            if (name.length() != 0) {
                name.append(", ");
            }
            name.append(listener.getName());
        }
        LOG.log(System.Logger.Level.WARNING, () -> "WEB0307: All SSL " + type + " disabled for network-listener " + String.valueOf(name) + ", using SSL implementation specific defaults");
    }

    public boolean isAllowLazyInit() {
        return this.ssl == null || Boolean.parseBoolean(this.ssl.getAllowLazyInit());
    }

    private String getKeyStorePassword(Ssl ssl) {
        if (PLAIN_PASSWORD_PROVIDER_NAME.equalsIgnoreCase(ssl.getKeyStorePasswordProvider())) {
            return ssl.getKeyStorePassword();
        }
        return this.getStorePasswordCustom(ssl.getKeyStorePassword());
    }

    private String getTrustStorePassword(Ssl ssl) {
        if (PLAIN_PASSWORD_PROVIDER_NAME.equalsIgnoreCase(ssl.getTrustStorePasswordProvider())) {
            return ssl.getTrustStorePassword();
        }
        return this.getStorePasswordCustom(ssl.getTrustStorePassword());
    }

    private String getStorePasswordCustom(String storePasswordProvider) {
        try {
            SecurePasswordProvider provider = (SecurePasswordProvider)Utils.newInstance(storePasswordProvider);
            assert (provider != null);
            return provider.getPassword();
        }
        catch (Exception e) {
            if (LOG.isLoggable(System.Logger.Level.WARNING)) {
                LOG.log(System.Logger.Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_SECURE_PASSWORD_INITIALIZATION_ERROR(storePasswordProvider), (Throwable)e);
            }
            return null;
        }
    }

    private static void setAttribute(SSLContextFactory sslContextFactory, String name, String value, String property, String defaultValue) {
        sslContextFactory.setAttribute(name, value == null ? System.getProperty(property, defaultValue) : value);
    }

    private static boolean isWantClientAuth(Ssl ssl) {
        String auth = ssl.getClientAuth();
        return auth != null && "want".equalsIgnoreCase(auth.trim());
    }

    private static boolean isNeedClientAuth(Ssl ssl) {
        if (Boolean.parseBoolean(ssl.getClientAuthEnabled())) {
            return true;
        }
        String auth = ssl.getClientAuth();
        return auth != null && "need".equalsIgnoreCase(auth.trim());
    }

    private static Set<String> getJSSECiphers(List<String> configuredCiphers) {
        HashSet<String> enabledCiphers = new HashSet<String>(configuredCiphers.size());
        for (String cipher : configuredCiphers) {
            String jsseCipher;
            if (cipher.isEmpty() || cipher.charAt(0) == '-') continue;
            if (cipher.charAt(0) == '+') {
                cipher = cipher.substring(1);
            }
            if ((jsseCipher = SSLConfigurator.getJSSECipher(cipher)) == null) {
                LOG.log(System.Logger.Level.WARNING, LogMessages.WARNING_GRIZZLY_CONFIG_SSL_UNKNOWN_CIPHER_ERROR(cipher));
                continue;
            }
            enabledCiphers.add(jsseCipher);
        }
        return enabledCiphers;
    }

    private static String getJSSECipher(String cipher) {
        CipherInfo ci = CipherInfo.getCipherInfo(cipher);
        return ci == null ? null : ci.getCipherName();
    }

    private final class InternalSSLContextConfigurator
    extends SSLContextConfigurator {
        private InternalSSLContextConfigurator() {
            super(false);
        }

        @Override
        public SSLContext createSSLContext() {
            return SSLConfigurator.this.configureSSL();
        }

        @Override
        public SSLContext createSSLContext(boolean throwException) {
            return SSLConfigurator.this.configureSSL();
        }

        @Override
        public boolean validateConfiguration(boolean needsKeyStore) {
            return super.validateConfiguration(needsKeyStore);
        }

        @Override
        public void setKeyManagerFactoryAlgorithm(String keyManagerFactoryAlgorithm) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyPass(String keyPass) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyPass(char[] keyPass) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyStoreFile(String keyStoreFile) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyStorePass(String keyStorePass) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyStorePass(char[] keyStorePass) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyStoreProvider(String keyStoreProvider) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setKeyStoreType(String keyStoreType) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setSecurityProtocol(String securityProtocol) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setTrustManagerFactoryAlgorithm(String trustManagerFactoryAlgorithm) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setTrustStoreFile(String trustStoreFile) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setTrustStorePass(String trustStorePass) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setTrustStoreProvider(String trustStoreProvider) {
            throw new IllegalStateException("The configuration is immutable");
        }

        @Override
        public void setTrustStoreType(String trustStoreType) {
            throw new IllegalStateException("The configuration is immutable");
        }
    }

    private static final class CipherInfo {
        private static final short SSL2 = 1;
        private static final short SSL3 = 2;
        private static final short TLS = 4;
        private static final String[][] OLD_CIPHER_MAPPING = new String[][]{{"rsa_null_md5", "SSL_RSA_WITH_NULL_MD5"}, {"rsa_null_sha", "SSL_RSA_WITH_NULL_SHA"}, {"rsa_rc4_40_md5", "SSL_RSA_EXPORT_WITH_RC4_40_MD5"}, {"rsa_rc4_128_md5", "SSL_RSA_WITH_RC4_128_MD5"}, {"rsa_rc4_128_sha", "SSL_RSA_WITH_RC4_128_SHA"}, {"rsa_3des_sha", "SSL_RSA_WITH_3DES_EDE_CBC_SHA"}, {"fips_des_sha", "SSL_RSA_WITH_DES_CBC_SHA"}, {"rsa_des_sha", "SSL_RSA_WITH_DES_CBC_SHA"}, {"SSL_RSA_WITH_NULL_MD5", "SSL_RSA_WITH_NULL_MD5"}, {"SSL_RSA_WITH_NULL_SHA", "SSL_RSA_WITH_NULL_SHA"}};
        private static final Map<String, CipherInfo> ciphers = new HashMap<String, CipherInfo>();
        private static final ReadWriteLock ciphersLock = new ReentrantReadWriteLock();
        private final String configName;
        private final String cipherName;
        private final short protocolVersion;

        private CipherInfo(String configName, String cipherName, short protocolVersion) {
            this.configName = configName;
            this.cipherName = cipherName;
            this.protocolVersion = protocolVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void updateCiphers(SSLContext sslContext) {
            SSLServerSocketFactory factory = sslContext.getServerSocketFactory();
            String[] supportedCiphers = factory.getDefaultCipherSuites();
            ciphersLock.writeLock().lock();
            try {
                for (String cipher : supportedCiphers) {
                    ciphers.put(cipher, new CipherInfo(cipher, cipher, 6));
                }
            }
            finally {
                ciphersLock.writeLock().unlock();
            }
        }

        public static CipherInfo getCipherInfo(String configName) {
            ciphersLock.readLock().lock();
            try {
                CipherInfo cipherInfo = ciphers.get(configName);
                return cipherInfo;
            }
            finally {
                ciphersLock.readLock().unlock();
            }
        }

        public String getConfigName() {
            return this.configName;
        }

        public String getCipherName() {
            return this.cipherName;
        }

        public boolean isSSL2() {
            return (this.protocolVersion & 1) == 1;
        }

        public boolean isSSL3() {
            return (this.protocolVersion & 2) == 2;
        }

        public boolean isTLS() {
            return (this.protocolVersion & 4) == 4;
        }

        static {
            for (String[] pair : OLD_CIPHER_MAPPING) {
                String nonStdName = pair[0];
                String stdName = pair[1];
                ciphers.put(nonStdName, new CipherInfo(nonStdName, stdName, 6));
            }
        }
    }
}

