/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.trust.impl;

import com.sun.xml.ws.api.security.trust.Claims;
import com.sun.xml.ws.api.security.trust.STSAttributeProvider;
import com.sun.xml.ws.api.security.trust.STSAuthorizationProvider;
import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.api.security.trust.config.STSConfiguration;
import com.sun.xml.ws.api.security.trust.config.TrustSPMetadata;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.trust.WSTrustElementFactory;
import com.sun.xml.ws.security.trust.WSTrustFactory;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.OnBehalfOf;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.elements.SecondaryParameters;
import com.sun.xml.ws.security.trust.elements.UseKey;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public abstract class IssueSamlTokenContract
implements com.sun.xml.ws.api.security.trust.IssueSamlTokenContract<BaseSTSRequest, BaseSTSResponse> {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.trust", "com.sun.xml.ws.security.trust.logging.LogStrings");
    protected static final String SAML_HOLDER_OF_KEY_1_0 = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
    protected static final String SAML_HOLDER_OF_KEY_2_0 = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
    protected static final String SAML_BEARER_1_0 = "urn:oasis:names:tc:SAML:1.0:cm:bearer";
    protected static final String SAML_BEARER_2_0 = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    protected static final String SAML_SENDER_VOUCHES_1_0 = "urn:oasis:names:tc:SAML:1.0:cm::sender-vouches";
    protected static final String SAML_SENDER_VOUCHES_2_0 = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
    protected STSConfiguration stsConfig;
    protected WSTrustVersion wstVer;
    protected String authnCtxClass;
    protected WSTrustElementFactory eleFac = WSTrustElementFactory.newInstance(WSTrustVersion.WS_TRUST_10);
    private static final int DEFAULT_KEY_SIZE = 256;

    protected IssueSamlTokenContract() {
    }

    @Override
    public void init(STSConfiguration stsConfig) {
        this.stsConfig = stsConfig;
        this.wstVer = (WSTrustVersion)stsConfig.getOtherOptions().get("WSTrustVersion");
        this.authnCtxClass = (String)stsConfig.getOtherOptions().get("AuthnContextClass");
        this.eleFac = WSTrustElementFactory.newInstance(this.wstVer);
    }

    @Override
    public BaseSTSResponse issue(BaseSTSRequest request, IssuedTokenContext context) throws WSTrustException {
        STSAuthorizationProvider authzProvider;
        Object oboToken;
        Subject subject;
        TrustSPMetadata spMd;
        RequestSecurityToken rst = (RequestSecurityToken)request;
        SecondaryParameters secParas = null;
        if (this.wstVer.getNamespaceURI().equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512")) {
            secParas = rst.getSecondaryParameters();
        }
        AppliesTo applies = rst.getAppliesTo();
        String appliesTo = null;
        X509Certificate serCert = null;
        if (applies != null) {
            List<Object> at = WSTrustUtil.parseAppliesTo(applies);
            for (int i = 0; i < at.size(); ++i) {
                Object obj = at.get(i);
                if (obj instanceof String) {
                    appliesTo = (String)obj;
                    continue;
                }
                if (!(obj instanceof X509Certificate)) continue;
                serCert = (X509Certificate)obj;
            }
        }
        if (serCert != null) {
            context.getOtherProperties().put("tagetedServiceCertificate", serCert);
        }
        if ((spMd = this.stsConfig.getTrustSPMetadata(appliesTo)) == null) {
            spMd = this.stsConfig.getTrustSPMetadata("default");
        }
        if (spMd == null) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0004_UNKNOWN_SERVICEPROVIDER(appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0004_UNKNOWN_SERVICEPROVIDER(appliesTo));
        }
        String tokenType = null;
        URI tokenTypeURI = rst.getTokenType();
        if (tokenTypeURI == null && secParas != null) {
            tokenTypeURI = secParas.getTokenType();
        }
        if ((tokenType = tokenTypeURI != null ? tokenTypeURI.toString() : spMd.getTokenType()) == null) {
            tokenType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
        }
        String keyType = null;
        URI keyTypeURI = rst.getKeyType();
        if (keyTypeURI == null && secParas != null) {
            keyTypeURI = secParas.getKeyType();
        }
        if ((keyType = keyTypeURI != null ? keyTypeURI.toString() : spMd.getKeyType()) == null) {
            keyType = this.wstVer.getSymmetricKeyTypeURI();
        }
        String encryptionAlgorithm = null;
        URI encryptionAlgorithmURI = rst.getEncryptionAlgorithm();
        if (encryptionAlgorithmURI == null && secParas != null) {
            encryptionAlgorithmURI = secParas.getEncryptionAlgorithm();
        }
        if (encryptionAlgorithmURI != null) {
            encryptionAlgorithm = encryptionAlgorithmURI.toString();
        }
        context.setEncryptionAlgorithm(encryptionAlgorithm);
        String signatureAlgorithm = null;
        URI signatureAlgorithmURI = rst.getSignatureAlgorithm();
        if (signatureAlgorithmURI == null && secParas != null) {
            signatureAlgorithmURI = secParas.getSignatureAlgorithm();
        }
        if (signatureAlgorithmURI != null) {
            signatureAlgorithm = signatureAlgorithmURI.toString();
        }
        context.setSignatureAlgorithm(signatureAlgorithm);
        String canonicalizationAlgorithm = null;
        URI canonicalizationAlgorithmURI = rst.getCanonicalizationAlgorithm();
        if (canonicalizationAlgorithmURI == null && secParas != null) {
            canonicalizationAlgorithmURI = secParas.getCanonicalizationAlgorithm();
        }
        if (canonicalizationAlgorithmURI != null) {
            canonicalizationAlgorithm = canonicalizationAlgorithmURI.toString();
        }
        context.setCanonicalizationAlgorithm(canonicalizationAlgorithm);
        URI keyWrapAlgorithmURI = null;
        if (secParas != null) {
            keyWrapAlgorithmURI = secParas.getKeyWrapAlgorithm();
        }
        if (keyWrapAlgorithmURI != null) {
            context.getOtherProperties().put("keyWrapAlgorithm", keyWrapAlgorithmURI.toString());
        }
        if ((subject = context.getRequestorSubject()) == null) {
            AccessControlContext acc = AccessController.getContext();
            subject = Subject.getSubject(acc);
        }
        if (subject == null) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0030_REQUESTOR_NULL());
            throw new WSTrustException(LogStringsMessages.WST_0030_REQUESTOR_NULL());
        }
        OnBehalfOf obo = rst.getOnBehalfOf();
        if (obo != null && (oboToken = obo.getAny()) != null) {
            subject.getPublicCredentials().add(this.eleFac.toElement(oboToken));
            String confirMethod = null;
            if (tokenType.equals("urn:oasis:names:tc:SAML:1.0:assertion") || tokenType.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1")) {
                confirMethod = SAML_SENDER_VOUCHES_1_0;
            } else if (tokenType.equals("urn:oasis:names:tc:SAML:2.0:assertion") || tokenType.equals("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0")) {
                confirMethod = SAML_SENDER_VOUCHES_2_0;
            }
            if (confirMethod != null) {
                this.stsConfig.getOtherOptions().put("Saml-Confirmation-Method", confirMethod);
            }
        }
        if (!(authzProvider = WSTrustFactory.getSTSAuthorizationProvider()).isAuthorized(subject, appliesTo, tokenType, keyType)) {
            String user = subject.getPrincipals().iterator().next().getName();
            log.log(Level.SEVERE, LogStringsMessages.WST_0015_CLIENT_NOT_AUTHORIZED(user, tokenType, appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0015_CLIENT_NOT_AUTHORIZED(user, tokenType, appliesTo));
        }
        Claims claims = rst.getClaims();
        if (claims == null && secParas != null) {
            claims = secParas.getClaims();
        }
        if (claims == null) {
            claims = this.eleFac.createClaims();
        }
        STSAttributeProvider attrProvider = WSTrustFactory.getSTSAttributeProvider();
        Map<QName, List<String>> claimedAttrs = attrProvider.getClaimedAttributes(subject, appliesTo, tokenType, claims);
        RequestedProofToken proofToken = null;
        Entropy serverEntropy = null;
        int keySize = 0;
        if (this.wstVer.getSymmetricKeyTypeURI().equals(keyType)) {
            proofToken = this.eleFac.createRequestedProofToken();
            byte[] clientEntr = null;
            Entropy clientEntropy = rst.getEntropy();
            if (clientEntropy != null) {
                BinarySecret clientBS = clientEntropy.getBinarySecret();
                if (clientBS == null) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, LogStringsMessages.WST_1009_NULL_BINARY_SECRET());
                    }
                } else {
                    clientEntr = clientBS.getRawValue();
                }
            }
            if ((keySize = (int)rst.getKeySize()) < 1 && secParas != null) {
                keySize = (int)secParas.getKeySize();
            }
            if (keySize < 1) {
                keySize = 256;
            }
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, LogStringsMessages.WST_1010_KEY_SIZE(keySize, 256));
            }
            byte[] key = WSTrustUtil.generateRandomSecret(keySize / 8);
            BinarySecret serverBS = this.eleFac.createBinarySecret(key, this.wstVer.getNonceBinarySecretTypeURI());
            serverEntropy = this.eleFac.createEntropy(serverBS);
            try {
                if (clientEntr != null && clientEntr.length > 0) {
                    proofToken.setComputedKey(URI.create(this.wstVer.getCKPSHA1algorithmURI()));
                    proofToken.setProofTokenType("ComputedKey");
                    key = SecurityUtil.P_SHA1(clientEntr, key, keySize / 8);
                } else {
                    proofToken.setProofTokenType("BinarySecret");
                    proofToken.setBinarySecret(serverBS);
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0013_ERROR_SECRET_KEY(this.wstVer.getCKPSHA1algorithmURI(), keySize, appliesTo), ex);
                throw new WSTrustException(LogStringsMessages.WST_0013_ERROR_SECRET_KEY(this.wstVer.getCKPSHA1algorithmURI(), keySize, appliesTo), ex);
            }
            context.setProofKey(key);
        } else if (this.wstVer.getPublicKeyTypeURI().equals(keyType)) {
            UseKey useKey = rst.getUseKey();
            if (useKey != null) {
                Element keyInfo = this.eleFac.toElement(useKey.getToken().getTokenValue());
                this.stsConfig.getOtherOptions().put("ConfirmationKeyInfo", keyInfo);
            }
            Set<Object> certs = subject.getPublicCredentials();
            boolean addedClientCert = false;
            for (Object o : certs) {
                if (!(o instanceof X509Certificate)) continue;
                X509Certificate clientCert = (X509Certificate)o;
                context.setRequestorCertificate(clientCert);
                addedClientCert = true;
            }
            if (!addedClientCert && useKey == null) {
                log.log(Level.SEVERE, LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
                throw new WSTrustException(LogStringsMessages.WST_0034_UNABLE_GET_CLIENT_CERT());
            }
        } else if (!this.wstVer.getBearerKeyTypeURI().equals(keyType)) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0025_INVALID_KEY_TYPE(keyType, appliesTo));
            throw new WSTrustException(LogStringsMessages.WST_0025_INVALID_KEY_TYPE(keyType, appliesTo));
        }
        String assertionId = "uuid-" + String.valueOf(UUID.randomUUID());
        RequestedSecurityToken reqSecTok = this.eleFac.createRequestedSecurityToken();
        Token samlToken = this.createSAMLAssertion(appliesTo, tokenType, keyType, assertionId, this.stsConfig.getIssuer(), claimedAttrs, context);
        reqSecTok.setToken(samlToken);
        String valueType = null;
        if ("urn:oasis:names:tc:SAML:1.0:assertion".equals(tokenType) || "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1".equals(tokenType)) {
            valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
        } else if ("urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType)) {
            valueType = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";
        }
        SecurityTokenReference samlReference = WSTrustUtil.createSecurityTokenReference(assertionId, valueType);
        RequestedAttachedReference raRef = this.eleFac.createRequestedAttachedReference(samlReference);
        RequestedUnattachedReference ruRef = this.eleFac.createRequestedUnattachedReference(samlReference);
        URI ctx = null;
        try {
            String rstCtx = rst.getContext();
            if (rstCtx != null) {
                ctx = new URI(rst.getContext());
            }
        }
        catch (URISyntaxException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WST_0014_URI_SYNTAX(), ex);
            throw new WSTrustException(LogStringsMessages.WST_0014_URI_SYNTAX(), ex);
        }
        long currentTime = WSTrustUtil.getCurrentTimeWithOffset();
        Lifetime lifetime = WSTrustUtil.createLifetime(currentTime, this.stsConfig.getIssuedTokenTimeout(), this.wstVer);
        RequestSecurityTokenResponse rstr = this.eleFac.createRSTRForIssue(rst.getTokenType(), ctx, reqSecTok, applies, raRef, ruRef, proofToken, serverEntropy, lifetime);
        if (keySize > 0) {
            rstr.setKeySize(keySize);
        }
        context.setSecurityToken(samlToken);
        context.setAttachedSecurityTokenReference(samlReference);
        context.setUnAttachedSecurityTokenReference(samlReference);
        context.setCreationTime(new Date(currentTime));
        context.setExpirationTime(new Date(currentTime + this.stsConfig.getIssuedTokenTimeout()));
        if (this.wstVer.getNamespaceURI().equals(WSTrustVersion.WS_TRUST_13.getNamespaceURI())) {
            ArrayList<RequestSecurityTokenResponse> list = new ArrayList<RequestSecurityTokenResponse>();
            list.add(rstr);
            return this.eleFac.createRSTRC(list);
        }
        return rstr;
    }

    public BaseSTSResponse issueMultiple(BaseSTSRequest request, IssuedTokenContext context) {
        throw new UnsupportedOperationException("Unsupported operation: issueMultiple");
    }

    @Override
    public BaseSTSResponse renew(BaseSTSRequest request, IssuedTokenContext context) {
        throw new UnsupportedOperationException("Unsupported operation: renew");
    }

    @Override
    public BaseSTSResponse cancel(BaseSTSRequest request, IssuedTokenContext context, Map issuedTokenCtxMap) {
        throw new UnsupportedOperationException("Unsupported operation: cancel");
    }

    @Override
    public BaseSTSResponse validate(BaseSTSRequest request, IssuedTokenContext context) {
        throw new UnsupportedOperationException("Unsupported operation: validate");
    }

    @Override
    public void handleUnsolicited(BaseSTSResponse rstr, IssuedTokenContext context) {
        throw new UnsupportedOperationException("Unsupported operation: handleUnsolicited");
    }

    @Override
    public abstract Token createSAMLAssertion(String var1, String var2, String var3, String var4, String var5, Map<QName, List<String>> var6, IssuedTokenContext var7) throws WSTrustException;
}

