/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.context;

import com.sun.faces.RIConstants;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.context.ResponseWriterWrapper;
import java.io.IOException;
import java.util.Map;

public class PartialResponseWriter
extends ResponseWriterWrapper {
    private boolean inChanges = false;
    private boolean inInsertBefore = false;
    private boolean inInsertAfter = false;
    private boolean inUpdate = false;
    public static final String RENDER_ALL_MARKER = "jakarta.faces.ViewRoot";
    public static final String VIEW_STATE_MARKER = "jakarta.faces.ViewState";

    public PartialResponseWriter(ResponseWriter writer) {
        super(writer);
    }

    @Override
    public void startDocument() throws IOException {
        ResponseWriter writer = this.getWrapped();
        String encoding = writer.getCharacterEncoding();
        if (encoding == null) {
            encoding = RIConstants.CHAR_ENCODING;
        }
        writer.writePreamble("<?xml version='1.0' encoding='" + encoding + "'?>\n");
        writer.startElement("partial-response", null);
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (null != ctx && ctx.getViewRoot() instanceof NamingContainer) {
            String id = ctx.getViewRoot().getContainerClientId(ctx);
            writer.writeAttribute("id", id, "id");
        }
    }

    @Override
    public void endDocument() throws IOException {
        this.endChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        if (!(writer instanceof PartialResponseWriter)) {
            writer.endElement("partial-response");
        }
        writer.endDocument();
    }

    public void startInsertBefore(String targetId) throws IOException {
        this.startChangesIfNecessary();
        this.inInsertBefore = true;
        ResponseWriter writer = this.getWrapped();
        writer.startElement("insert", null);
        writer.startElement("before", null);
        writer.writeAttribute("id", targetId, null);
        writer.startCDATA();
    }

    public void startInsertAfter(String targetId) throws IOException {
        this.startChangesIfNecessary();
        this.inInsertAfter = true;
        ResponseWriter writer = this.getWrapped();
        writer.startElement("insert", null);
        writer.startElement("after", null);
        writer.writeAttribute("id", targetId, null);
        writer.startCDATA();
    }

    public void endInsert() throws IOException {
        ResponseWriter writer = this.getWrapped();
        writer.endCDATA();
        if (this.inInsertBefore) {
            writer.endElement("before");
            this.inInsertBefore = false;
        } else if (this.inInsertAfter) {
            writer.endElement("after");
            this.inInsertAfter = false;
        }
        writer.endElement("insert");
    }

    public void startUpdate(String targetId) throws IOException {
        this.startChangesIfNecessary();
        this.inUpdate = true;
        ResponseWriter writer = this.getWrapped();
        writer.startElement("update", null);
        writer.writeAttribute("id", targetId, null);
        writer.startCDATA();
    }

    public void endUpdate() throws IOException {
        ResponseWriter writer = this.getWrapped();
        writer.endCDATA();
        writer.endElement("update");
        this.inUpdate = false;
    }

    public void updateAttributes(String targetId, Map<String, String> attributes) throws IOException {
        this.startChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.startElement("attributes", null);
        writer.writeAttribute("id", targetId, null);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            writer.startElement("attribute", null);
            writer.writeAttribute("name", entry.getKey(), null);
            writer.writeAttribute("value", entry.getValue(), null);
            writer.endElement("attribute");
        }
        writer.endElement("attributes");
    }

    public void delete(String targetId) throws IOException {
        this.startChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.startElement("delete", null);
        writer.writeAttribute("id", targetId, null);
        writer.endElement("delete");
    }

    public void redirect(String url) throws IOException {
        this.endChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.startElement("redirect", null);
        writer.writeAttribute("url", url, null);
        writer.endElement("redirect");
    }

    public void startEval() throws IOException {
        this.startChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.startElement("eval", null);
        writer.startCDATA();
    }

    public void endEval() throws IOException {
        ResponseWriter writer = this.getWrapped();
        writer.endCDATA();
        writer.endElement("eval");
    }

    public void startExtension(Map<String, String> attributes) throws IOException {
        this.startChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.startElement("extension", null);
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                writer.writeAttribute(entry.getKey(), entry.getValue(), null);
            }
        }
    }

    public void endExtension() throws IOException {
        ResponseWriter writer = this.getWrapped();
        writer.endElement("extension");
    }

    public void startError(String errorName) throws IOException {
        this.endUpdateIfNecessary();
        this.endChangesIfNecessary();
        ResponseWriter writer = this.getWrapped();
        writer.startElement("error", null);
        writer.startElement("error-name", null);
        writer.write(errorName);
        writer.endElement("error-name");
        writer.startElement("error-message", null);
        writer.startCDATA();
    }

    public void endError() throws IOException {
        ResponseWriter writer = this.getWrapped();
        writer.endCDATA();
        writer.endElement("error-message");
        writer.endElement("error");
    }

    private void startChangesIfNecessary() throws IOException {
        if (!this.inChanges) {
            ResponseWriter writer = this.getWrapped();
            writer.startElement("changes", null);
            this.inChanges = true;
        }
    }

    private void endUpdateIfNecessary() throws IOException {
        if (this.inUpdate) {
            this.endUpdate();
        }
    }

    private void endChangesIfNecessary() throws IOException {
        if (this.inChanges) {
            ResponseWriter writer = this.getWrapped();
            writer.endElement("changes");
            this.inChanges = false;
        }
    }
}

