/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.dynamicany;

import com.sun.corba.ee.impl.corba.AnyImpl;
import com.sun.corba.ee.impl.dynamicany.DynAnyBasicImpl;
import com.sun.corba.ee.impl.dynamicany.DynAnyImpl;
import com.sun.corba.ee.impl.dynamicany.DynArrayImpl;
import com.sun.corba.ee.impl.dynamicany.DynEnumImpl;
import com.sun.corba.ee.impl.dynamicany.DynFixedImpl;
import com.sun.corba.ee.impl.dynamicany.DynSequenceImpl;
import com.sun.corba.ee.impl.dynamicany.DynStructImpl;
import com.sun.corba.ee.impl.dynamicany.DynUnionImpl;
import com.sun.corba.ee.impl.dynamicany.DynValueBoxImpl;
import com.sun.corba.ee.impl.dynamicany.DynValueImpl;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ORB;
import java.math.BigDecimal;
import org.omg.CORBA.Any;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;

public class DynAnyUtil {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;

    static boolean isConsistentType(TypeCode typeCode) {
        int kind = typeCode.kind().value();
        return kind != 13 && kind != 31 && kind != 32;
    }

    static boolean isConstructedDynAny(DynAny dynAny) {
        int kind = dynAny.type().kind().value();
        return kind == 19 || kind == 15 || kind == 20 || kind == 16 || kind == 17 || kind == 28 || kind == 29 || kind == 30;
    }

    static DynAny createMostDerivedDynAny(Any any, ORB orb, boolean copyValue) throws InconsistentTypeCode {
        if (any == null || !DynAnyUtil.isConsistentType(any.type())) {
            throw new InconsistentTypeCode();
        }
        switch (any.type().kind().value()) {
            case 19: {
                return new DynSequenceImpl(orb, any, copyValue);
            }
            case 15: {
                return new DynStructImpl(orb, any, copyValue);
            }
            case 20: {
                return new DynArrayImpl(orb, any, copyValue);
            }
            case 16: {
                return new DynUnionImpl(orb, any, copyValue);
            }
            case 17: {
                return new DynEnumImpl(orb, any, copyValue);
            }
            case 28: {
                return new DynFixedImpl(orb, any, copyValue);
            }
            case 29: {
                return new DynValueImpl(orb, any, copyValue);
            }
            case 30: {
                return new DynValueBoxImpl(orb, any, copyValue);
            }
        }
        return new DynAnyBasicImpl(orb, any, copyValue);
    }

    static DynAny createMostDerivedDynAny(TypeCode typeCode, ORB orb) throws InconsistentTypeCode {
        if (typeCode == null || !DynAnyUtil.isConsistentType(typeCode)) {
            throw new InconsistentTypeCode();
        }
        switch (typeCode.kind().value()) {
            case 19: {
                return new DynSequenceImpl(orb, typeCode);
            }
            case 15: {
                return new DynStructImpl(orb, typeCode);
            }
            case 20: {
                return new DynArrayImpl(orb, typeCode);
            }
            case 16: {
                return new DynUnionImpl(orb, typeCode);
            }
            case 17: {
                return new DynEnumImpl(orb, typeCode);
            }
            case 28: {
                return new DynFixedImpl(orb, typeCode);
            }
            case 29: {
                return new DynValueImpl(orb, typeCode);
            }
            case 30: {
                return new DynValueBoxImpl(orb, typeCode);
            }
        }
        return new DynAnyBasicImpl(orb, typeCode);
    }

    static Any extractAnyFromStream(TypeCode memberType, InputStream input, ORB orb) {
        return AnyImpl.extractAnyFromStream(memberType, input, orb);
    }

    static Any createDefaultAnyOfType(TypeCode typeCode, ORB orb) {
        Any returnValue = orb.create_any();
        switch (typeCode.kind().value()) {
            case 8: {
                returnValue.insert_boolean(false);
                break;
            }
            case 2: {
                returnValue.insert_short((short)0);
                break;
            }
            case 4: {
                returnValue.insert_ushort((short)0);
                break;
            }
            case 3: {
                returnValue.insert_long(0);
                break;
            }
            case 5: {
                returnValue.insert_ulong(0);
                break;
            }
            case 23: {
                returnValue.insert_longlong(0L);
                break;
            }
            case 24: {
                returnValue.insert_ulonglong(0L);
                break;
            }
            case 6: {
                returnValue.insert_float(0.0f);
                break;
            }
            case 7: {
                returnValue.insert_double(0.0);
                break;
            }
            case 10: {
                returnValue.insert_octet((byte)0);
                break;
            }
            case 9: {
                returnValue.insert_char('\u0000');
                break;
            }
            case 26: {
                returnValue.insert_wchar('\u0000');
                break;
            }
            case 18: {
                returnValue.type(typeCode);
                returnValue.insert_string("");
                break;
            }
            case 27: {
                returnValue.type(typeCode);
                returnValue.insert_wstring("");
                break;
            }
            case 14: {
                returnValue.insert_Object(null);
                break;
            }
            case 12: {
                returnValue.insert_TypeCode(returnValue.type());
                break;
            }
            case 11: {
                returnValue.insert_any(orb.create_any());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 29: 
            case 30: {
                returnValue.type(typeCode);
                break;
            }
            case 28: {
                returnValue.insert_fixed(new BigDecimal("0.0"), typeCode);
                break;
            }
            case 1: 
            case 13: 
            case 21: 
            case 31: 
            case 32: {
                returnValue.type(typeCode);
                break;
            }
            case 0: {
                break;
            }
            case 25: {
                throw wrapper.tkLongDoubleNotSupported();
            }
            default: {
                throw wrapper.typecodeNotSupported();
            }
        }
        return returnValue;
    }

    static Any copy(Any inAny, ORB orb) {
        return new AnyImpl(orb, inAny);
    }

    static DynAny convertToNative(DynAny dynAny, ORB orb) {
        if (dynAny instanceof DynAnyImpl) {
            return dynAny;
        }
        try {
            return DynAnyUtil.createMostDerivedDynAny(dynAny.to_any(), orb, true);
        }
        catch (InconsistentTypeCode ictc) {
            return null;
        }
    }

    static boolean isInitialized(Any any) {
        boolean isInitialized = ((AnyImpl)any).isInitialized();
        switch (any.type().kind().value()) {
            case 18: {
                return isInitialized && any.extract_string() != null;
            }
            case 27: {
                return isInitialized && any.extract_wstring() != null;
            }
        }
        return isInitialized;
    }

    static boolean set_current_component(DynAny dynAny, DynAny currentComponent) {
        if (currentComponent != null) {
            try {
                dynAny.rewind();
                do {
                    if (dynAny.current_component() != currentComponent) continue;
                    return true;
                } while (dynAny.next());
            }
            catch (TypeMismatch typeMismatch) {
                // empty catch block
            }
        }
        return false;
    }
}

