/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.naming.cosnaming;

import java.io.StringWriter;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextPackage.InvalidName;

public class InterOperableNamingImpl {
    public String convertToString(NameComponent[] theNameComponents) {
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        for (NameComponent nc : theNameComponents) {
            String temp = this.convertNameComponentToString(nc);
            sb.append(temp);
            if (first) {
                first = false;
                continue;
            }
            sb.append('/');
        }
        return sb.toString();
    }

    private boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private boolean contains(String str, char ch) {
        return str.indexOf(ch) != -1;
    }

    private String convertNameComponentToString(NameComponent theNameComponent) {
        String id = this.addEscape(theNameComponent.id);
        String kind = this.addEscape(theNameComponent.kind);
        StringBuffer sb = new StringBuffer();
        if (!this.isEmpty(id)) {
            sb.append(id);
        }
        sb.append('.');
        if (!this.isEmpty(kind)) {
            sb.append(kind);
        }
        return sb.toString();
    }

    private String addEscape(String value) {
        if (value != null && (this.contains(value, '.') || this.contains(value, '/'))) {
            StringBuffer theNewValue = new StringBuffer();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '.' || c == '/') {
                    theNewValue.append('\\');
                }
                theNewValue.append(c);
            }
            return theNewValue.toString();
        }
        return value;
    }

    public NameComponent[] convertToNameComponent(String theStringifiedName) throws InvalidName {
        String[] components = this.breakStringToNameComponents(theStringifiedName);
        if (components == null || components.length == 0) {
            return null;
        }
        NameComponent[] theNameComponents = new NameComponent[components.length];
        for (int i = 0; i < components.length; ++i) {
            theNameComponents[i] = this.createNameComponentFromString(components[i]);
        }
        return theNameComponents;
    }

    private String[] breakStringToNameComponents(String sname) {
        int[] theIndices = new int[100];
        int theIndicesIndex = 0;
        int index = 0;
        while (index <= sname.length()) {
            theIndices[theIndicesIndex] = sname.indexOf(47, index);
            if (theIndices[theIndicesIndex] == -1) {
                index = sname.length() + 1;
                continue;
            }
            if (theIndices[theIndicesIndex] > 0 && sname.charAt(theIndices[theIndicesIndex] - 1) == '\\') {
                index = theIndices[theIndicesIndex] + 1;
                theIndices[theIndicesIndex] = -1;
                continue;
            }
            index = theIndices[theIndicesIndex] + 1;
            ++theIndicesIndex;
        }
        if (theIndicesIndex == 0) {
            String[] tempString = new String[]{sname};
            return tempString;
        }
        if (theIndicesIndex != 0) {
            ++theIndicesIndex;
        }
        return this.StringComponentsFromIndices(theIndices, theIndicesIndex, sname);
    }

    private String[] StringComponentsFromIndices(int[] theIndices, int indicesCount, String theStringifiedName) {
        String[] theStringComponents = new String[indicesCount];
        int firstIndex = 0;
        int lastIndex = theIndices[0];
        for (int i = 0; i < indicesCount; ++i) {
            theStringComponents[i] = theStringifiedName.substring(firstIndex, lastIndex);
            if (theIndices[i] < theStringifiedName.length() - 1 && theIndices[i] != -1) {
                firstIndex = theIndices[i] + 1;
            } else {
                firstIndex = 0;
                i = indicesCount;
            }
            if (i + 1 < theIndices.length && theIndices[i + 1] < theStringifiedName.length() - 1 && theIndices[i + 1] != -1) {
                lastIndex = theIndices[i + 1];
            } else {
                i = indicesCount;
            }
            if (firstIndex == 0 || i != indicesCount) continue;
            theStringComponents[indicesCount - 1] = theStringifiedName.substring(firstIndex);
        }
        return theStringComponents;
    }

    private NameComponent createNameComponentFromString(String theStringifiedNameComponent) throws InvalidName {
        String id = null;
        String kind = null;
        if (theStringifiedNameComponent == null || theStringifiedNameComponent.length() == 0 || theStringifiedNameComponent.endsWith(".")) {
            throw new InvalidName();
        }
        int index = theStringifiedNameComponent.indexOf(46, 0);
        if (index == -1) {
            id = theStringifiedNameComponent;
        } else if (index == 0) {
            if (theStringifiedNameComponent.length() != 1) {
                kind = theStringifiedNameComponent.substring(1);
            }
        } else if (theStringifiedNameComponent.charAt(index - 1) != '\\') {
            id = theStringifiedNameComponent.substring(0, index);
            kind = theStringifiedNameComponent.substring(index + 1);
        } else {
            boolean kindfound = false;
            while (index < theStringifiedNameComponent.length() && !kindfound) {
                if ((index = theStringifiedNameComponent.indexOf(46, index + 1)) > 0) {
                    if (theStringifiedNameComponent.charAt(index - 1) == '\\') continue;
                    kindfound = true;
                    continue;
                }
                index = theStringifiedNameComponent.length();
            }
            if (kindfound) {
                id = theStringifiedNameComponent.substring(0, index);
                kind = theStringifiedNameComponent.substring(index + 1);
            } else {
                id = theStringifiedNameComponent;
            }
        }
        id = this.cleanEscapeCharacter(id);
        kind = this.cleanEscapeCharacter(kind);
        if (id == null) {
            id = "";
        }
        if (kind == null) {
            kind = "";
        }
        return new NameComponent(id, kind);
    }

    private String cleanEscapeCharacter(String theString) {
        if (theString == null || theString.length() == 0) {
            return theString;
        }
        int index = theString.indexOf(92);
        if (index == 0) {
            return theString;
        }
        String src = theString;
        StringBuilder dest = new StringBuilder();
        for (int i = 0; i < theString.length(); ++i) {
            char d;
            char c = src.charAt(i);
            if (c != '\\') {
                dest.append(c);
                continue;
            }
            if (i + 1 >= theString.length() || !Character.isLetterOrDigit(d = src.charAt(i + 1))) continue;
            dest.append(c);
        }
        return new String(dest);
    }

    public String createURLBasedAddress(String address, String name) throws InvalidAddress {
        String theurl = null;
        if (address == null || address.length() == 0) {
            throw new InvalidAddress();
        }
        theurl = "corbaname:" + address + "#" + this.encode(name);
        return theurl;
    }

    private String encode(String stringToEncode) {
        StringWriter theStringAfterEscape = new StringWriter();
        boolean byteCount = false;
        for (int i = 0; i < stringToEncode.length(); ++i) {
            char c = stringToEncode.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                theStringAfterEscape.write(c);
                continue;
            }
            if (c == ';' || c == '/' || c == '?' || c == ':' || c == '@' || c == '&' || c == '=' || c == '+' || c == '$' || c == ';' || c == '-' || c == '_' || c == '.' || c == '!' || c == '~' || c == '*' || c == ' ' || c == '(' || c == ')') {
                theStringAfterEscape.write(c);
                continue;
            }
            theStringAfterEscape.write(37);
            String hexString = Integer.toHexString(c);
            theStringAfterEscape.write(hexString);
        }
        return theStringAfterEscape.toString();
    }
}

