/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.transport.connection;

import com.sun.corba.ee.impl.transport.connection.ConnectionCacheNonBlockingBase;
import com.sun.corba.ee.spi.transport.concurrent.ConcurrentQueue;
import com.sun.corba.ee.spi.transport.concurrent.ConcurrentQueueFactory;
import com.sun.corba.ee.spi.transport.connection.Connection;
import com.sun.corba.ee.spi.transport.connection.ConnectionFinder;
import com.sun.corba.ee.spi.transport.connection.ContactInfo;
import com.sun.corba.ee.spi.transport.connection.OutboundConnectionCache;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class OutboundConnectionCacheImpl<C extends Connection>
extends ConnectionCacheNonBlockingBase<C>
implements OutboundConnectionCache<C> {
    private final int maxParallelConnections;
    private final ConcurrentMap<ContactInfo<C>, CacheEntry<C>> entryMap;
    private final ConcurrentMap<C, ConnectionState<C>> connectionMap;

    @Override
    public int maxParallelConnections() {
        return this.maxParallelConnections;
    }

    @Override
    protected String thisClassName() {
        return "OutboundConnectionCacheImpl";
    }

    public OutboundConnectionCacheImpl(String cacheType, int highWaterMark, int numberToReclaim, int maxParallelConnections, long ttl) {
        super(cacheType, highWaterMark, numberToReclaim, ttl);
        this.maxParallelConnections = maxParallelConnections;
        this.entryMap = new ConcurrentHashMap<ContactInfo<C>, CacheEntry<C>>();
        this.connectionMap = new ConcurrentHashMap<C, ConnectionState<C>>();
        this.reclaimableConnections = ConcurrentQueueFactory.makeBlockingConcurrentQueue(ttl);
    }

    @Override
    public C get(ContactInfo<C> cinfo, ConnectionFinder<C> finder) throws IOException {
        return this.get(cinfo);
    }

    @Override
    public C get(ContactInfo<C> cinfo) throws IOException {
        CacheEntry<C> entry = this.getEntry(cinfo);
        Connection result = null;
        int totalConnections = this.totalBusy.get() + this.totalIdle.get();
        if (totalConnections >= this.highWaterMark()) {
            this.reclaim();
        }
        do {
            ConnectionState<Connection> cs;
            if ((result = (Connection)entry.idleConnections.poll().value()) == null) {
                if (this.canCreateNewConnection(entry)) {
                    result = cinfo.createConnection();
                    cs = new ConnectionState<Connection>(cinfo, entry, result);
                    this.connectionMap.put(result, cs);
                    cs.busyCount.incrementAndGet();
                    entry.busyConnections.offer(result);
                    this.totalBusy.incrementAndGet();
                    continue;
                }
                result = (Connection)entry.busyConnections.poll().value();
                if (result == null) continue;
                entry.busyConnections.offer(result);
                continue;
            }
            cs = (ConnectionState<Connection>)this.connectionMap.get(result);
            if (cs == null) {
                result = null;
                continue;
            }
            ConcurrentQueue.Handle handle = cs.reclaimableHandle;
            if (handle == null) continue;
            if (handle.remove()) {
                this.totalIdle.decrementAndGet();
                this.totalBusy.incrementAndGet();
                entry.busyConnections.offer(result);
                continue;
            }
            result = null;
        } while (result == null);
        return (C)result;
    }

    @Override
    public void release(C conn, int numResponsesExpected) {
        ConnectionState cs = (ConnectionState)this.connectionMap.get(conn);
        if (cs == null) {
            return;
        }
        int numResp = cs.expectedResponseCount.addAndGet(numResponsesExpected);
        int numBusy = cs.busyCount.decrementAndGet();
        if (numBusy == 0) {
            ConcurrentQueue.Handle busyHandle = cs.busyHandle;
            CacheEntry entry = cs.entry;
            boolean wasOnBusy = false;
            if (busyHandle != null) {
                wasOnBusy = busyHandle.remove();
            }
            if (wasOnBusy) {
                if (cs.busyCount.get() > 0) {
                    cs.busyHandle = entry.busyConnections.offer(conn);
                } else {
                    if (cs.expectedResponseCount.get() == 0) {
                        cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
                        this.totalBusy.decrementAndGet();
                    }
                    cs.idleHandle = entry.idleConnections.offer(conn);
                }
            }
        }
    }

    @Override
    public void responseReceived(C conn) {
        ConnectionState cs = (ConnectionState)this.connectionMap.get(conn);
        if (cs == null) {
            return;
        }
        ConcurrentQueue.Handle idleHandle = cs.idleHandle;
        CacheEntry entry = cs.entry;
        int waitCount = cs.expectedResponseCount.decrementAndGet();
        if (waitCount == 0) {
            boolean wasOnIdle = false;
            if (cs != null) {
                wasOnIdle = cs.idleHandle.remove();
            }
            if (wasOnIdle) {
                cs.reclaimableHandle = this.reclaimableConnections.offer(conn);
            }
        }
    }

    @Override
    public void close(C conn) {
        ConcurrentQueue.Handle ih;
        ConcurrentQueue.Handle bh;
        ConnectionState cs = (ConnectionState)this.connectionMap.remove(conn);
        if (cs == null) {
            return;
        }
        CacheEntry entry = (CacheEntry)this.entryMap.remove(cs.cinfo);
        ConcurrentQueue.Handle rh = cs.reclaimableHandle;
        if (rh != null) {
            rh.remove();
        }
        if ((bh = cs.busyHandle) != null) {
            bh.remove();
        }
        if ((ih = cs.idleHandle) != null) {
            ih.remove();
        }
        try {
            conn.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private CacheEntry<C> getEntry(ContactInfo<C> cinfo) {
        CacheEntry entry = new CacheEntry();
        CacheEntry result = this.entryMap.putIfAbsent(cinfo, entry);
        if (result != null) {
            return result;
        }
        return entry;
    }

    @Override
    private boolean canCreateNewConnection(CacheEntry<C> entry) {
        int totalConnections = this.totalBusy.get() + this.totalIdle.get();
        int totalConnectionsInEntry = entry.totalConnections();
        return totalConnectionsInEntry == 0 || totalConnections < this.highWaterMark() && totalConnectionsInEntry < this.maxParallelConnections;
    }

    @Override
    public boolean canCreateNewConnection(ContactInfo<C> cinfo) {
        CacheEntry entry = (CacheEntry)this.entryMap.get(cinfo);
        if (entry == null) {
            return true;
        }
        return this.canCreateNewConnection(entry);
    }

    private static final class CacheEntry<C extends Connection> {
        final ConcurrentQueue<C> idleConnections = ConcurrentQueueFactory.makeBlockingConcurrentQueue(0L);
        final ConcurrentQueue<C> busyConnections = ConcurrentQueueFactory.makeBlockingConcurrentQueue(0L);

        private CacheEntry() {
        }

        public int totalConnections() {
            return this.idleConnections.size() + this.busyConnections.size();
        }
    }

    private static final class ConnectionState<C extends Connection> {
        final ContactInfo<C> cinfo;
        final C connection;
        final CacheEntry<C> entry;
        final AtomicInteger busyCount;
        final AtomicInteger expectedResponseCount;
        volatile ConcurrentQueue.Handle reclaimableHandle;
        volatile ConcurrentQueue.Handle idleHandle;
        volatile ConcurrentQueue.Handle busyHandle;

        ConnectionState(ContactInfo<C> cinfo, CacheEntry<C> entry, C conn) {
            this.cinfo = cinfo;
            this.connection = conn;
            this.entry = entry;
            this.busyCount = new AtomicInteger();
            this.expectedResponseCount = new AtomicInteger();
            this.reclaimableHandle = null;
            this.idleHandle = null;
            this.busyHandle = null;
        }
    }
}

