/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.descriptors.MultitenantPolicy;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathQName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.record.XMLRecord;

public class QNameInheritancePolicy
extends InheritancePolicy {
    private NamespaceResolver namespaceResolver;
    private boolean usesXsiType = false;

    public QNameInheritancePolicy() {
    }

    public QNameInheritancePolicy(ClassDescriptor desc) {
        super(desc);
    }

    @Override
    protected void updateTables() {
        Vector<DatabaseTable> childTables = this.getDescriptor().getTables();
        Vector<DatabaseTable> parentTables = this.getParentDescriptor().getTables();
        Vector<DatabaseTable> uniqueTables = Helper.concatenateUniqueVectors(childTables, parentTables);
        this.getDescriptor().setTables(uniqueTables);
        if (this.getDescriptor().isXMLDescriptor() && this.getParentDescriptor().isXMLDescriptor() && ((XMLDescriptor)this.getDescriptor()).getDefaultRootElementField() == null) {
            ((XMLDescriptor)this.getDescriptor()).setDefaultRootElementField(((XMLDescriptor)this.getParentDescriptor()).getDefaultRootElementField());
        }
        if (childTables.isEmpty()) {
            this.getDescriptor().setInternalDefaultTable();
        } else {
            this.getDescriptor().setInternalDefaultTable(uniqueTables.get(uniqueTables.indexOf(childTables.get(0))));
        }
    }

    @Override
    public void preInitialize(AbstractSession session) throws DescriptorException {
        if (this.isChildDescriptor()) {
            this.updateTables();
            if (this.getParentDescriptor().hasMultitenantPolicy()) {
                MultitenantPolicy clonedMultitenantPolicy = this.getParentDescriptor().getMultitenantPolicy().clone(this.getDescriptor());
                this.getDescriptor().setMultitenantPolicy(clonedMultitenantPolicy);
            }
            this.setClassIndicatorMapping(this.getParentDescriptor().getInheritancePolicy().getClassIndicatorMapping());
            this.setShouldUseClassNameAsIndicator(this.getParentDescriptor().getInheritancePolicy().shouldUseClassNameAsIndicator());
            this.getDescriptor().setPrimaryKeyFields(this.getParentDescriptor().getPrimaryKeyFields());
            this.getDescriptor().setAdditionalTablePrimaryKeyFields(Helper.concatenateMaps(this.getParentDescriptor().getAdditionalTablePrimaryKeyFields(), this.getDescriptor().getAdditionalTablePrimaryKeyFields()));
            this.setClassIndicatorField(this.getParentDescriptor().getInheritancePolicy().getClassIndicatorField());
            if (!this.getDescriptor().usesSequenceNumbers()) {
                this.getDescriptor().setSequenceNumberField(this.getParentDescriptor().getSequenceNumberField());
                this.getDescriptor().setSequenceNumberName(this.getParentDescriptor().getSequenceNumberName());
            }
        } else {
            this.getDescriptor().setInternalDefaultTable();
        }
        this.initializeClassExtractor(session);
        if (!this.isChildDescriptor()) {
            if (this.getClassIndicatorField() == null && !this.hasClassExtractor()) {
                session.getIntegrityChecker().handleError(DescriptorException.classIndicatorFieldNotFound(this.getDescriptor(), this.getDescriptor()));
            }
            if (this.getClassIndicatorField() != null) {
                this.setClassIndicatorField(this.getDescriptor().buildField(this.getClassIndicatorField()));
                if (this.shouldUseClassNameAsIndicator()) {
                    this.getClassIndicatorField().setType(CoreClassConstants.STRING);
                } else if (!this.getClassIndicatorMapping().isEmpty()) {
                    Class<?> type = null;
                    Iterator fieldValuesEnum = this.getClassIndicatorMapping().values().iterator();
                    while (fieldValuesEnum.hasNext() && type == null) {
                        Object value = fieldValuesEnum.next();
                        if (value.getClass() == this.getClass().getClass()) continue;
                        type = value.getClass();
                    }
                    this.getClassIndicatorField().setType(type);
                }
                this.getDescriptor().getFields().addElement(this.getClassIndicatorField());
            }
        }
    }

    @Override
    public void initialize(AbstractSession session) {
        super.initialize(session);
        if (!this.shouldUseClassNameAsIndicator()) {
            XPathFragment frag;
            if (this.classIndicatorField != null && (frag = ((XMLField)this.classIndicatorField).getXPathFragment()).getLocalName().equals("type") && "http://www.w3.org/2001/XMLSchema-instance".equals(frag.getNamespaceURI())) {
                this.usesXsiType = true;
            }
            for (Map.Entry entry : new HashMap(this.getClassIndicatorMapping()).entrySet()) {
                Object key = entry.getKey();
                if (key instanceof String) {
                    XPathQName qname;
                    String indicatorValue = (String)key;
                    if (!this.usesXsiType || this.namespaceResolver == null) {
                        qname = new XPathQName(indicatorValue, true);
                    } else {
                        int index = indicatorValue.indexOf(58);
                        if (index != -1 && this.namespaceResolver != null) {
                            String prefix = indicatorValue.substring(0, index);
                            String localPart = indicatorValue.substring(index + 1);
                            String uri = this.namespaceResolver.resolveNamespacePrefix(prefix);
                            qname = new XPathQName(uri, localPart, true);
                        } else {
                            qname = new XPathQName(this.namespaceResolver.getDefaultNamespaceURI(), indicatorValue, true);
                        }
                    }
                    this.getClassIndicatorMapping().put(qname, entry.getValue());
                    continue;
                }
                if (!(key instanceof QName)) continue;
                XPathQName xpathQName = new XPathQName((QName)key, true);
                this.getClassIndicatorMapping().put(xpathQName, entry.getValue());
            }
        }
        if (this.getClassIndicatorField() != null) {
            XMLField classIndicatorXMLField;
            try {
                classIndicatorXMLField = (XMLField)this.getClassIndicatorField();
            }
            catch (ClassCastException ex) {
                classIndicatorXMLField = new XMLField(this.getClassIndicatorField().getName());
                this.setClassIndicatorField(classIndicatorXMLField);
            }
            XPathFragment frag = classIndicatorXMLField.getLastXPathFragment();
            if (frag != null && frag.hasNamespace() && frag.getPrefix() != null && this.namespaceResolver != null) {
                String uri = this.namespaceResolver.resolveNamespacePrefix(frag.getPrefix());
                classIndicatorXMLField.getLastXPathFragment().setNamespaceURI(uri);
            }
        }
    }

    @Override
    public Class<?> classFromRow(AbstractRecord rowFromDatabase, AbstractSession session) throws DescriptorException {
        Class concreteClass;
        ((XMLRecord)rowFromDatabase).setSession(session);
        if (this.hasClassExtractor() || this.shouldUseClassNameAsIndicator()) {
            return super.classFromRow(rowFromDatabase, session);
        }
        Object indicator = rowFromDatabase.get(this.getClassIndicatorField());
        if (indicator == AbstractRecord.noEntry) {
            return null;
        }
        if (indicator == null) {
            return null;
        }
        if (indicator instanceof String) {
            boolean namespaceAware = ((XMLRecord)rowFromDatabase).isNamespaceAware();
            String indicatorValue = (String)indicator;
            int index = -1;
            if (namespaceAware) {
                index = indicatorValue.indexOf(((XMLRecord)rowFromDatabase).getNamespaceSeparator());
            }
            if (index == -1) {
                if (namespaceAware && this.usesXsiType) {
                    String uri = ((XMLRecord)rowFromDatabase).resolveNamespacePrefix(null);
                    if (uri == null && ((XMLRecord)rowFromDatabase).getNamespaceResolver() != null) {
                        uri = ((XMLRecord)rowFromDatabase).getNamespaceResolver().getDefaultNamespaceURI();
                    }
                    XPathQName qname = new XPathQName(uri, indicatorValue, namespaceAware);
                    concreteClass = (Class)this.classIndicatorMapping.get(qname);
                } else {
                    XPathQName qname = new XPathQName(indicatorValue, namespaceAware);
                    concreteClass = (Class)this.classIndicatorMapping.get(qname);
                }
            } else {
                String prefix = indicatorValue.substring(0, index);
                String localPart = indicatorValue.substring(index + 1);
                String uri = ((XMLRecord)rowFromDatabase).resolveNamespacePrefix(prefix);
                if (uri != null) {
                    XPathQName qname = new XPathQName(uri, localPart, namespaceAware);
                    concreteClass = (Class)this.classIndicatorMapping.get(qname);
                } else {
                    concreteClass = (Class)this.classIndicatorMapping.get(indicatorValue);
                }
            }
        } else {
            concreteClass = (Class)this.classIndicatorMapping.get(indicator);
        }
        if (concreteClass == null) {
            throw DescriptorException.missingClassForIndicatorFieldValue(indicator, this.getDescriptor());
        }
        return concreteClass;
    }

    public void setNamespaceResolver(NamespaceResolver resolver) {
        this.namespaceResolver = resolver;
    }

    @Override
    public void setClassIndicatorFieldName(String fieldName) {
        if (fieldName == null) {
            this.setClassIndicatorField((DatabaseField)null);
        } else {
            this.setClassIndicatorField(new XMLField(fieldName));
        }
    }

    @Override
    public void addClassIndicatorFieldToRow(AbstractRecord databaseRow) {
        if (this.hasClassExtractor()) {
            return;
        }
        DatabaseField field = this.getClassIndicatorField();
        Object value = this.getClassIndicatorValue();
        if (this.usesXsiType) {
            boolean namespaceAware;
            boolean bl = namespaceAware = ((XMLRecord)databaseRow).isNamespaceAware() || ((XMLRecord)databaseRow).hasCustomNamespaceMapper();
            if (value instanceof String) {
                if (namespaceAware) {
                    if (((XMLRecord)databaseRow).getNamespaceSeparator() != ':') {
                        value = ((String)value).replace(':', ((XMLRecord)databaseRow).getNamespaceSeparator());
                    }
                } else {
                    int colonIndex = ((String)value).indexOf(58);
                    if (colonIndex > -1) {
                        value = ((String)value).substring(colonIndex + 1);
                    }
                }
            }
        }
        databaseRow.put((Object)field, value);
    }
}

