/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.sessions.Session;

public class PopulationManager {
    protected Map<Class<?>, Map<String, Object>> registeredObjects = new Hashtable();
    protected static PopulationManager defaultManager;

    public void addAllObjectsForAbstractClass(Class<?> objectsClass, AbstractSession session, Vector<Object> allObjects) {
        CoreDescriptor descriptor = session.getDescriptor((Class)objectsClass);
        this.addAllObjectsForClass(objectsClass, allObjects);
        for (ClassDescriptor child : ((ClassDescriptor)descriptor).getInheritancePolicy().getChildDescriptors()) {
            this.addAllObjectsForAbstractClass(child.getJavaClass(), session, allObjects);
        }
    }

    public void addAllObjectsForAbstractClass(Class<?> objectsClass, Session session, Vector<Object> allObjects) {
        this.addAllObjectsForAbstractClass(objectsClass, (AbstractSession)session, allObjects);
    }

    public void addAllObjectsForClass(Class<?> objectsClass, List<Object> allObjects) {
        if (!this.getRegisteredObjects().containsKey(objectsClass)) {
            return;
        }
        for (Object object : this.getRegisteredObjects().get(objectsClass).values()) {
            allObjects.add(object);
        }
    }

    public boolean containsObject(Class<?> objectsClass, String objectsName) {
        return this.getRegisteredObjects().containsKey(objectsClass) && this.getRegisteredObjects().get(objectsClass).containsKey(objectsName);
    }

    public boolean containsObject(Object objectToCheck, String objectsName) {
        return this.containsObject(objectToCheck.getClass(), objectsName);
    }

    public List<Class<?>> getAllClasses() {
        Vector allClasses = new Vector();
        allClasses.addAll(this.getRegisteredObjects().keySet());
        return allClasses;
    }

    public Vector<Object> getAllObjects() {
        Vector<Object> allObjects = new Vector<Object>();
        for (Class<?> eachClass : this.getAllClasses()) {
            this.addAllObjectsForClass(eachClass, allObjects);
        }
        return allObjects;
    }

    public List<Object> getAllObjectsForAbstractClass(Class<?> objectsClass) {
        Vector<Object> allObjects = new Vector<Object>();
        return allObjects;
    }

    public List<Object> getAllObjectsForAbstractClass(Class<?> objectsClass, AbstractSession session) {
        CoreDescriptor descriptor = session.getDescriptor((Class)objectsClass);
        Vector<Object> allObjects = new Vector<Object>();
        this.addAllObjectsForClass(objectsClass, allObjects);
        if (((ClassDescriptor)descriptor).hasInheritance()) {
            for (ClassDescriptor child : ((ClassDescriptor)descriptor).getInheritancePolicy().getChildDescriptors()) {
                this.addAllObjectsForClass(child.getJavaClass(), allObjects);
            }
        }
        return allObjects;
    }

    public Vector<Object> getAllObjectsForClass(Class<?> objectsClass) {
        Vector<Object> allObjects = new Vector<Object>();
        this.addAllObjectsForClass(objectsClass, allObjects);
        return allObjects;
    }

    public static PopulationManager getDefaultManager() {
        if (defaultManager == null) {
            defaultManager = new PopulationManager();
        }
        return defaultManager;
    }

    public Object getObject(Class<?> objectsClass, String objectsName) {
        if (!this.getRegisteredObjects().containsKey(objectsClass)) {
            return null;
        }
        return this.getRegisteredObjects().get(objectsClass).get(objectsName);
    }

    public Map<Class<?>, Map<String, Object>> getRegisteredObjects() {
        return this.registeredObjects;
    }

    public Object registerObject(Class<?> javaClass, Object objectToRegister, String objectsName) {
        if (!this.getRegisteredObjects().containsKey(javaClass)) {
            this.getRegisteredObjects().put(javaClass, new Hashtable());
        }
        this.getRegisteredObjects().get(javaClass).put(objectsName, objectToRegister);
        return objectToRegister;
    }

    public Object registerObject(Object objectToRegister, String objectsName) {
        if (!this.getRegisteredObjects().containsKey(objectToRegister.getClass())) {
            this.getRegisteredObjects().put(objectToRegister.getClass(), new Hashtable());
        }
        this.getRegisteredObjects().get(objectToRegister.getClass()).put(objectsName, objectToRegister);
        return objectToRegister;
    }

    public void removeObject(Class<?> classToRemove, String objectsName) {
        if (this.getRegisteredObjects().containsKey(classToRemove)) {
            this.getRegisteredObjects().get(classToRemove).remove(objectsName);
        }
    }

    public Object removeObject(Object objectToRemove, String objectsName) {
        this.removeObject(objectToRemove.getClass(), objectsName);
        return objectToRemove;
    }

    public static void resetDefaultManager() {
        defaultManager = null;
    }

    public static void setDefaultManager(PopulationManager theDefaultManager) {
        defaultManager = theDefaultManager;
    }

    public void setRegisteredObjects(Map<Class<?>, Map<String, Object>> registeredObjects) {
        this.registeredObjects = registeredObjects;
    }
}

