/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import org.apache.catalina.Realm;

public class GenericPrincipal
implements Principal {
    protected String name;
    protected Realm realm;
    protected char[] password;
    protected String[] roles = new String[0];

    public GenericPrincipal(Realm realm, String name, char[] password) {
        this(realm, name, password, null);
    }

    public GenericPrincipal(Realm realm, String name, char[] password, List<String> roles) {
        this.realm = realm;
        this.name = name;
        char[] cArray = this.password = password != null ? (char[])password.clone() : null;
        if (roles != null) {
            this.roles = new String[roles.size()];
            this.roles = roles.toArray(this.roles);
            if (this.roles.length > 0) {
                Arrays.sort(this.roles);
            }
        }
    }

    public GenericPrincipal(String name, char[] password, List<String> roles) {
        this.name = name;
        char[] cArray = this.password = password != null ? (char[])password.clone() : null;
        if (roles != null) {
            this.roles = new String[roles.size()];
            this.roles = roles.toArray(this.roles);
            if (this.roles.length > 0) {
                Arrays.sort(this.roles);
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public char[] getPassword() {
        return this.password != null ? (char[])this.password.clone() : null;
    }

    public Realm getRealm() {
        return this.realm;
    }

    void setRealm(Realm realm) {
        this.realm = realm;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public boolean hasRole(String role) {
        if ("*".equals(role)) {
            return true;
        }
        if (role == null) {
            return false;
        }
        return Arrays.binarySearch(this.roles, role) >= 0;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("GenericPrincipal[");
        sb.append(this.name);
        sb.append("(");
        for (String role : this.roles) {
            sb.append(role).append(",");
        }
        sb.append(")]");
        return sb.toString();
    }
}

