/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.runlevel.internal;

import jakarta.inject.Inject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.DescriptorVisibility;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.Visibility;
import org.glassfish.hk2.runlevel.CurrentlyRunningException;
import org.glassfish.hk2.runlevel.RunLevelController;
import org.glassfish.hk2.runlevel.RunLevelFuture;
import org.glassfish.hk2.runlevel.internal.CurrentTaskFuture;
import org.glassfish.hk2.runlevel.internal.CurrentTaskFutureWrapper;
import org.glassfish.hk2.runlevel.internal.WasCancelledException;
import org.glassfish.hk2.runlevel.internal.WouldBlockException;
import org.glassfish.hk2.runlevel.utilities.Utilities;
import org.jvnet.hk2.annotations.Service;

@Service
@Visibility(value=DescriptorVisibility.LOCAL)
public class AsyncRunLevelContext {
    private static final String DEBUG_CONTEXT_PROPERTY = "org.jvnet.hk2.properties.debug.runlevel.context";
    private static final boolean DEBUG_CONTEXT = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.parseBoolean(System.getProperty(AsyncRunLevelContext.DEBUG_CONTEXT_PROPERTY, "false"));
        }
    });
    private static final Logger logger = Logger.getLogger(AsyncRunLevelContext.class.getName());
    private static final Timer TIMER = new Timer("hk2-asyncrunlevelcontext", true);
    private static final ThreadFactory THREAD_FACTORY = new RunLevelThreadFactory();
    final ReentrantLock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final org.glassfish.hk2.utilities.reflection.Logger hk2Logger = org.glassfish.hk2.utilities.reflection.Logger.getLogger();
    private int currentLevel = -2;
    private CurrentTaskFutureWrapper currentTask = null;
    private static final Executor DEFAULT_EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true), THREAD_FACTORY);
    private final Map<ActiveDescriptor<?>, Object> backingMap = new HashMap();
    private final Map<ActiveDescriptor<?>, Throwable> levelErrorMap = new HashMap();
    private boolean wasCancelled = false;
    private final HashMap<ActiveDescriptor<?>, Long> creatingDescriptors = new HashMap();
    private final HashSet<ActiveDescriptor<?>> hardCancelledDescriptors = new HashSet();
    private final LinkedList<ActiveDescriptor<?>> orderedCreationList = new LinkedList();
    private Executor executor = DEFAULT_EXECUTOR;
    private final ServiceLocator locator;
    private int maxThreads = Integer.MAX_VALUE;
    private RunLevelController.ThreadingPolicy policy = RunLevelController.ThreadingPolicy.FULLY_THREADED;
    private long cancelTimeout = 5000L;
    private Integer modeOverride = null;

    @Inject
    private AsyncRunLevelContext(ServiceLocator locator) {
        this.locator = locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <U> U findOrCreate(ActiveDescriptor<U> activeDescriptor, ServiceHandle<?> root) {
        int localCurrentLevel;
        Integer localModeOverride;
        Object rootBlockObject;
        String oneLineDescriptor = null;
        if (DEBUG_CONTEXT) {
            oneLineDescriptor = AsyncRunLevelContext.oneLineDescriptor(activeDescriptor);
            this.hk2Logger.debug("AsyncRunLevelController findOrCreate for " + oneLineDescriptor + " and root " + AsyncRunLevelContext.oneLineRoot(root));
        }
        boolean throwWouldBlock = root == null ? false : ((rootBlockObject = root.getServiceData()) == null ? false : (Boolean)rootBlockObject);
        Object retVal = null;
        long tid = -1L;
        this.lock.lock();
        try {
            localModeOverride = this.modeOverride;
            retVal = this.backingMap.get(activeDescriptor);
            if (retVal != null) {
                if (DEBUG_CONTEXT) {
                    this.hk2Logger.debug("AsyncRunLevelController found " + oneLineDescriptor);
                }
                Object object = retVal;
                return (U)object;
            }
            Throwable previousException = this.levelErrorMap.get(activeDescriptor);
            if (previousException != null) {
                if (DEBUG_CONTEXT) {
                    this.hk2Logger.debug("AsyncRunLevelController tried once, it failed, rethrowing " + oneLineDescriptor, previousException);
                }
                if (previousException instanceof RuntimeException) {
                    throw (RuntimeException)previousException;
                }
                throw new RuntimeException(previousException);
            }
            if (this.hardCancelledDescriptors.contains(activeDescriptor)) {
                if (DEBUG_CONTEXT) {
                    this.hk2Logger.debug("AsyncRunLevelController hard cancelled " + oneLineDescriptor);
                }
                throw new MultiException((Throwable)new WasCancelledException((Descriptor)activeDescriptor), false);
            }
            while (this.creatingDescriptors.containsKey(activeDescriptor)) {
                long holdingLock;
                if (DEBUG_CONTEXT) {
                    this.hk2Logger.debug("AsyncRunLevelController already being created " + oneLineDescriptor);
                }
                if ((holdingLock = this.creatingDescriptors.get(activeDescriptor).longValue()) == Thread.currentThread().getId()) {
                    if (DEBUG_CONTEXT) {
                        this.hk2Logger.debug("AsyncRunLevelController circular dependency " + oneLineDescriptor);
                    }
                    throw new MultiException((Throwable)new IllegalStateException("Circular dependency involving " + activeDescriptor.getImplementation() + " was found.  Full descriptor is " + activeDescriptor));
                }
                if (throwWouldBlock) {
                    if (DEBUG_CONTEXT) {
                        this.hk2Logger.debug("AsyncRunLevelController would block optimization " + oneLineDescriptor);
                    }
                    throw new MultiException((Throwable)new WouldBlockException((Descriptor)activeDescriptor), false);
                }
                try {
                    this.notEmpty.await();
                }
                catch (InterruptedException ie) {
                    throw new MultiException((Throwable)ie);
                }
            }
            if (DEBUG_CONTEXT) {
                this.hk2Logger.debug("AsyncRunLevelController finished creating wait for " + oneLineDescriptor);
            }
            if ((retVal = this.backingMap.get(activeDescriptor)) != null) {
                if (DEBUG_CONTEXT) {
                    this.hk2Logger.debug("AsyncRunLevelController second chance found " + oneLineDescriptor);
                }
                Object holdingLock = retVal;
                return (U)holdingLock;
            }
            previousException = this.levelErrorMap.get(activeDescriptor);
            if (previousException != null) {
                if (DEBUG_CONTEXT) {
                    this.hk2Logger.debug("AsyncRunLevelController service already threw " + oneLineDescriptor);
                }
                if (previousException instanceof RuntimeException) {
                    throw (RuntimeException)previousException;
                }
                throw new RuntimeException(previousException);
            }
            if (this.hardCancelledDescriptors.contains(activeDescriptor)) {
                if (DEBUG_CONTEXT) {
                    this.hk2Logger.debug("AsyncRunLevelController second chance hard cancel " + oneLineDescriptor);
                }
                throw new MultiException((Throwable)new WasCancelledException((Descriptor)activeDescriptor), false);
            }
            tid = Thread.currentThread().getId();
            if (DEBUG_CONTEXT) {
                this.hk2Logger.debug("AsyncRunLevelController am creating " + oneLineDescriptor + " in thread " + tid);
            }
            this.creatingDescriptors.put(activeDescriptor, tid);
            localCurrentLevel = this.currentLevel;
            if (this.currentTask != null && this.currentTask.isUp() && ++localCurrentLevel > this.currentTask.getProposedLevel()) {
                localCurrentLevel = this.currentTask.getProposedLevel();
            }
        }
        finally {
            this.lock.unlock();
        }
        Throwable error = null;
        try {
            int mode = Utilities.getRunLevelMode(this.locator, activeDescriptor, localModeOverride);
            if (mode == 1) {
                this.validate(activeDescriptor, localCurrentLevel);
            }
            if (DEBUG_CONTEXT) {
                this.hk2Logger.debug("AsyncRunLevelController prior to actual create " + oneLineDescriptor + " in thread " + tid);
            }
            retVal = activeDescriptor.create(root);
            if (DEBUG_CONTEXT) {
                this.hk2Logger.debug("AsyncRunLevelController after actual create " + oneLineDescriptor + " in thread " + tid);
            }
            Object object = retVal;
            return (U)object;
        }
        catch (Throwable th) {
            if (DEBUG_CONTEXT) {
                this.hk2Logger.debug("AsyncRunLevelController got exception for " + oneLineDescriptor + " in thread " + tid, th);
            }
            if (th instanceof MultiException) {
                if (!CurrentTaskFuture.isWouldBlock((MultiException)th)) {
                    error = th;
                }
            } else {
                error = th;
            }
            if (th instanceof RuntimeException) {
                throw (RuntimeException)th;
            }
            throw new RuntimeException(th);
        }
        finally {
            this.lock.lock();
            try {
                boolean hardCancelled = this.hardCancelledDescriptors.remove(activeDescriptor);
                if (retVal != null) {
                    if (!hardCancelled) {
                        this.backingMap.put(activeDescriptor, retVal);
                        this.orderedCreationList.addFirst(activeDescriptor);
                    }
                    if (this.wasCancelled || hardCancelled) {
                        if (DEBUG_CONTEXT) {
                            this.hk2Logger.debug("AsyncRunLevelController cancellation race failed " + oneLineDescriptor + " in thread " + tid);
                        }
                        MultiException cancelledException = new MultiException((Throwable)new WasCancelledException((Descriptor)activeDescriptor), false);
                        if (!hardCancelled) {
                            this.levelErrorMap.put(activeDescriptor, cancelledException);
                        }
                        this.creatingDescriptors.remove(activeDescriptor);
                        this.notEmpty.signalAll();
                        if (DEBUG_CONTEXT) {
                            this.hk2Logger.debug("AsyncRunLevelController other threads notified cancellation path for " + oneLineDescriptor + " in thread " + tid);
                        }
                        throw cancelledException;
                    }
                } else if (error != null && !hardCancelled) {
                    this.levelErrorMap.put(activeDescriptor, error);
                }
                this.creatingDescriptors.remove(activeDescriptor);
                this.notEmpty.signalAll();
                if (DEBUG_CONTEXT) {
                    this.hk2Logger.debug("AsyncRunLevelController other threads notified for " + oneLineDescriptor + " in thread " + tid);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        this.lock.lock();
        try {
            boolean bl = this.backingMap.containsKey(descriptor);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean wouldBlockRightNow(ActiveDescriptor<?> desc) {
        this.lock.lock();
        try {
            boolean bl = this.creatingDescriptors.containsKey(desc);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void hardCancelOne(ActiveDescriptor<?> descriptor) {
        if (this.creatingDescriptors.containsKey(descriptor)) {
            this.hardCancelledDescriptors.add(descriptor);
        }
    }

    public void destroyOne(ActiveDescriptor<?> descriptor) {
        Object retVal = null;
        this.lock.lock();
        try {
            retVal = this.backingMap.remove(descriptor);
            if (retVal == null) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        descriptor.dispose(retVal);
    }

    private void validate(ActiveDescriptor<?> descriptor, int currentLevel) throws IllegalStateException {
        Integer runLevel = Utilities.getRunLevelValue(this.locator, descriptor);
        if (runLevel > currentLevel) {
            throw new IllegalStateException("Service " + descriptor.getImplementation() + " was started at level " + currentLevel + " but it has a run level of " + runLevel + ".  The full descriptor is " + descriptor);
        }
    }

    int getCurrentLevel() {
        this.lock.lock();
        try {
            int n = this.currentLevel;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    void levelCancelled() {
        this.lock.lock();
        try {
            this.wasCancelled = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setCurrentLevel(int currentLevel) {
        this.lock.lock();
        try {
            this.currentLevel = currentLevel;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setPolicy(RunLevelController.ThreadingPolicy policy) {
        this.lock.lock();
        try {
            this.policy = policy;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setExecutor(Executor executor) {
        this.lock.lock();
        try {
            this.executor = executor == null ? DEFAULT_EXECUTOR : executor;
        }
        finally {
            this.lock.unlock();
        }
    }

    Executor getExecutor() {
        this.lock.lock();
        try {
            Executor executor = this.executor;
            return executor;
        }
        finally {
            this.lock.unlock();
        }
    }

    RunLevelController.ThreadingPolicy getPolicy() {
        this.lock.lock();
        try {
            RunLevelController.ThreadingPolicy threadingPolicy = this.policy;
            return threadingPolicy;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ActiveDescriptor<?>> getOrderedListOfServicesAtLevel(int level) {
        this.lock.lock();
        try {
            LinkedList retVal = new LinkedList();
            while (!this.orderedCreationList.isEmpty()) {
                ActiveDescriptor<?> zero = this.orderedCreationList.get(0);
                int zeroLevel = Utilities.getRunLevelValue(this.locator, zero);
                if (zeroLevel < level) {
                    LinkedList linkedList = retVal;
                    return linkedList;
                }
                retVal.add(this.orderedCreationList.remove(0));
            }
            LinkedList linkedList = retVal;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RunLevelFuture proceedTo(int level) throws CurrentlyRunningException {
        CurrentTaskFutureWrapper localTask;
        this.lock.lock();
        try {
            boolean fullyThreaded = this.policy.equals((Object)RunLevelController.ThreadingPolicy.FULLY_THREADED);
            if (this.currentTask != null) {
                throw new CurrentlyRunningException(this.currentTask);
            }
            localTask = this.currentTask = new CurrentTaskFutureWrapper(new CurrentTaskFuture(this, this.executor, this.locator, level, this.maxThreads, fullyThreaded, this.cancelTimeout, TIMER));
        }
        finally {
            this.lock.unlock();
        }
        localTask.getDelegate().go();
        return localTask;
    }

    void jobDone() {
        this.lock.lock();
        try {
            this.currentTask = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    public RunLevelFuture getCurrentFuture() {
        this.lock.lock();
        try {
            CurrentTaskFutureWrapper currentTaskFutureWrapper = this.currentTask;
            return currentTaskFutureWrapper;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setMaximumThreads(int maximum) {
        this.lock.lock();
        try {
            this.maxThreads = maximum < 1 ? 1 : maximum;
        }
        finally {
            this.lock.unlock();
        }
    }

    int getMaximumThreads() {
        this.lock.lock();
        try {
            int n = this.maxThreads;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    void clearErrors() {
        this.lock.lock();
        try {
            this.levelErrorMap.clear();
            this.wasCancelled = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setCancelTimeout(long cancelTimeout) {
        this.lock.lock();
        try {
            this.cancelTimeout = cancelTimeout;
        }
        finally {
            this.lock.unlock();
        }
    }

    long getCancelTimeout() {
        this.lock.lock();
        try {
            long l = this.cancelTimeout;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    Integer getModeOverride() {
        this.lock.lock();
        try {
            Integer n = this.modeOverride;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setModeOverride(Integer modeOverride) {
        this.lock.lock();
        try {
            this.modeOverride = modeOverride;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static String oneLineDescriptor(ActiveDescriptor<?> descriptor) {
        if (descriptor == null) {
            return "null-descriptor";
        }
        return descriptor.getImplementation() + (String)(descriptor.getName() != null ? "/" + descriptor.getName() : "") + "(" + descriptor.getServiceId() + "," + descriptor.getLocatorId() + "," + System.identityHashCode(descriptor) + ")";
    }

    private static String oneLineRoot(ServiceHandle<?> root) {
        if (root == null) {
            return "null-root";
        }
        root.getActiveDescriptor();
        return "root(" + AsyncRunLevelContext.oneLineDescriptor(root.getActiveDescriptor()) + "," + System.identityHashCode(root) + ")";
    }

    private static class RunLevelThreadFactory
    implements ThreadFactory {
        private RunLevelThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            RunLevelControllerThread activeThread = new RunLevelControllerThread(runnable);
            logger.log(Level.FINE, "new thread: {0}", activeThread);
            return activeThread;
        }
    }

    private static class RunLevelControllerThread
    extends Thread {
        private RunLevelControllerThread(Runnable r) {
            super(r);
            this.setDaemon(true);
            this.setName(this.getClass().getSimpleName() + "-" + System.currentTimeMillis());
        }
    }
}

