/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import org.jboss.jdeparser.ArrayLookupJExpr;
import org.jboss.jdeparser.BinaryJExpr;
import org.jboss.jdeparser.CachingLinkedHashMap;
import org.jboss.jdeparser.CastJExpr;
import org.jboss.jdeparser.CondJExpr;
import org.jboss.jdeparser.FieldRefJExpr;
import org.jboss.jdeparser.InnerJAnonymousClassDef;
import org.jboss.jdeparser.InnerNewJCall;
import org.jboss.jdeparser.InstanceJCall;
import org.jboss.jdeparser.InstanceOfJExpr;
import org.jboss.jdeparser.JAnonymousClassDef;
import org.jboss.jdeparser.JAssignableExpr;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.ParenJExpr;
import org.jboss.jdeparser.Tokens$;
import org.jboss.jdeparser.UnaryJExpr;
import org.jboss.jdeparser.Writable;

abstract class AbstractJExpr
implements JExpr,
Writable {
    private final int prec;
    private CachingLinkedHashMap<String, JAssignableExpr> fieldCache;
    private JExpr length;

    protected AbstractJExpr(int prec) {
        this.prec = prec;
    }

    static AbstractJExpr of(JExpr expr) {
        if (expr instanceof AbstractJExpr) {
            return (AbstractJExpr)expr;
        }
        throw new IllegalArgumentException("Expression from different implementation");
    }

    @Override
    public JExpr plus(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.PLUS, this, (AbstractJExpr)e1, 5);
    }

    @Override
    public JExpr minus(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.MINUS, this, (AbstractJExpr)e1, 5);
    }

    @Override
    public JExpr times(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.TIMES, this, (AbstractJExpr)e1, 4);
    }

    @Override
    public JExpr div(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.DIV, this, (AbstractJExpr)e1, 4);
    }

    @Override
    public JExpr mod(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.MOD, this, (AbstractJExpr)e1, 4);
    }

    @Override
    public JExpr neg() {
        return new UnaryJExpr(Tokens$.PUNCT.UNOP.MINUS, this);
    }

    @Override
    public JExpr band(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.BAND, this, (AbstractJExpr)e1, 9);
    }

    @Override
    public JExpr bor(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.BOR, this, (AbstractJExpr)e1, 11);
    }

    @Override
    public JExpr bxor(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.BXOR, this, (AbstractJExpr)e1, 10);
    }

    @Override
    public JExpr shr(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.SHR, this, (AbstractJExpr)e1, 6);
    }

    @Override
    public JExpr lshr(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.LSHR, this, (AbstractJExpr)e1, 6);
    }

    @Override
    public JExpr shl(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.SHL, this, (AbstractJExpr)e1, 6);
    }

    @Override
    public JExpr comp() {
        return new UnaryJExpr(Tokens$.PUNCT.UNOP.COMP, this);
    }

    @Override
    public JExpr and(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.LAND, this, (AbstractJExpr)e1, 12);
    }

    @Override
    public JExpr or(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.LOR, this, (AbstractJExpr)e1, 13);
    }

    @Override
    public JExpr not() {
        return new UnaryJExpr(Tokens$.PUNCT.UNOP.NOT, this);
    }

    @Override
    public JExpr eq(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.EQ, this, (AbstractJExpr)e1, 8);
    }

    @Override
    public JExpr ne(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.NE, this, (AbstractJExpr)e1, 8);
    }

    @Override
    public JExpr lt(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.LT, this, (AbstractJExpr)e1, 7);
    }

    @Override
    public JExpr gt(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.GT, this, (AbstractJExpr)e1, 7);
    }

    @Override
    public JExpr le(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.LE, this, (AbstractJExpr)e1, 7);
    }

    @Override
    public JExpr ge(JExpr e1) {
        return new BinaryJExpr(Tokens$.PUNCT.BINOP.GE, this, (AbstractJExpr)e1, 7);
    }

    @Override
    public JExpr cond(JExpr ifTrue, JExpr ifFalse) {
        return new CondJExpr(this, (AbstractJExpr)ifTrue, (AbstractJExpr)ifFalse);
    }

    @Override
    public JExpr paren() {
        return new ParenJExpr(this);
    }

    @Override
    public JExpr _instanceof(String type) {
        return this._instanceof(JTypes.typeNamed(type));
    }

    @Override
    public JExpr _instanceof(JType type) {
        return new InstanceOfJExpr(this, type);
    }

    @Override
    public JExpr _instanceof(Class<?> type) {
        return this._instanceof(JTypes.typeOf(type));
    }

    @Override
    public JExpr cast(String type) {
        return new CastJExpr(this, JTypes.typeNamed(type));
    }

    @Override
    public JExpr cast(JType type) {
        return new CastJExpr(this, type);
    }

    @Override
    public JExpr cast(Class<?> type) {
        return new CastJExpr(this, JTypes.typeOf(type));
    }

    @Override
    public JCall call(String name) {
        return new InstanceJCall(this, name);
    }

    @Override
    public JCall _new(String type) {
        return new InnerNewJCall(this, JTypes.typeNamed(type));
    }

    @Override
    public JCall _new(JType type) {
        return new InnerNewJCall(this, type);
    }

    @Override
    public JCall _new(Class<?> type) {
        return new InnerNewJCall(this, JTypes.typeOf(type));
    }

    @Override
    public JAnonymousClassDef _newAnon(String type) {
        return new InnerJAnonymousClassDef(this, JTypes.typeNamed(type));
    }

    @Override
    public JAnonymousClassDef _newAnon(JType type) {
        return new InnerJAnonymousClassDef(this, type);
    }

    @Override
    public JAnonymousClassDef _newAnon(Class<?> type) {
        return new InnerJAnonymousClassDef(this, JTypes.typeOf(type));
    }

    @Override
    public JAssignableExpr field(String name) {
        JAssignableExpr expr;
        CachingLinkedHashMap<String, JAssignableExpr> map = this.fieldCache;
        if (map == null) {
            this.fieldCache = new CachingLinkedHashMap();
            map = this.fieldCache;
        }
        if ((expr = (JAssignableExpr)map.get(name)) == null) {
            expr = new FieldRefJExpr(this, name);
            map.put(name, expr);
        }
        return expr;
    }

    @Override
    public JAssignableExpr $v(String name) {
        return this.field(name);
    }

    @Override
    public JAssignableExpr idx(JExpr idx) {
        return new ArrayLookupJExpr(this, (AbstractJExpr)idx);
    }

    @Override
    public JExpr idx(int idx) {
        return new ArrayLookupJExpr(this, (AbstractJExpr)JExprs.decimal(idx));
    }

    @Override
    public JExpr length() {
        JExpr length = this.length;
        if (length == null) {
            length = this.length = new FieldRefJExpr(this, "length");
        }
        return length;
    }

    public int prec() {
        return this.prec;
    }
}

