/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.jdeparser.AbstractJHtmlComment;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.HtmlCommentContent;
import org.jboss.jdeparser.JHtmlTag;
import org.jboss.jdeparser.SourceFileWriter;

class ImplJHtmlTag
extends AbstractJHtmlComment
implements JHtmlTag,
HtmlCommentContent {
    private final String tag;
    private final boolean newLine;
    private final boolean writeClose;
    private Map<String, String> attributes;

    ImplJHtmlTag(String tag, boolean newLine, boolean writeClose) {
        this.tag = tag;
        this.newLine = newLine;
        this.writeClose = writeClose;
    }

    String getTag() {
        return this.tag;
    }

    boolean isNewLine() {
        return this.newLine;
    }

    @Override
    public JHtmlTag attribute(String name) {
        this.doAdd(name, null);
        return this;
    }

    @Override
    public JHtmlTag attribute(String name, String value) {
        this.doAdd(name, value);
        return this;
    }

    private void doAdd(String name, String value) {
        Map<String, String> attributes = this.attributes;
        if (attributes == null) {
            this.attributes = attributes = new LinkedHashMap<String, String>();
        }
        attributes.put(name, value);
    }

    Iterable<Map.Entry<String, String>> attributes() {
        Map<String, String> attributes = this.attributes;
        return attributes == null ? Collections.emptySet() : attributes.entrySet();
    }

    void writeOpenTag(SourceFileWriter writer) throws IOException {
        if (this.newLine) {
            writer.nl();
        }
        writer.writeUnescaped('<');
        writer.writeEscaped(this.tag);
        Map<String, String> attributes = this.attributes;
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                writer.sp();
                writer.writeEscaped(entry.getKey());
                String value = entry.getValue();
                if (value == null) continue;
                writer.writeUnescaped('=');
                writer.writeUnescaped('\"');
                writer.writeEscaped(value);
                writer.writeUnescaped('\"');
            }
        }
        writer.writeUnescaped('>');
        if (this.newLine) {
            writer.nl();
        }
    }

    void writeCloseTag(SourceFileWriter writer) throws IOException {
        if (this.writeClose) {
            if (this.newLine) {
                writer.nl();
            }
            writer.writeEscaped('<');
            writer.writeEscaped('/');
            writer.writeEscaped(this.tag);
            writer.writeEscaped('>');
        }
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        this.writeOpenTag(writer);
        writer.pushIndent(FormatPreferences.Indentation.HTML_TAG);
        try {
            super.write(writer);
        }
        finally {
            writer.popIndent(FormatPreferences.Indentation.HTML_TAG);
        }
    }
}

