/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdeparser;

import java.io.IOException;
import org.jboss.jdeparser.AbstractJExpr;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.SourceFileWriter;
import org.jboss.jdeparser.Tokens;

class IntegerJExpr
extends AbstractJExpr
implements JExpr {
    private final int val;
    private final int radix;

    IntegerJExpr(int val, int radix) {
        super(0);
        this.val = val;
        this.radix = radix;
    }

    @Override
    public void write(SourceFileWriter writer) throws IOException {
        writer.addWordSpace();
        writer.write(Tokens.$NUMBER);
        switch (this.radix) {
            case 2: {
                writer.writeEscaped("0b");
                break;
            }
            case 16: {
                writer.writeEscaped("0x");
            }
        }
        writer.writeEscaped(Integer.toString(this.val, this.radix));
    }
}

