/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.apt;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.jboss.logging.processor.model.ClassType;
import org.jboss.logging.processor.util.ElementHelper;

abstract class AbstractClassType
implements ClassType {
    protected final ProcessingEnvironment processingEnv;
    protected final Elements elements;
    protected final Types types;
    protected final TypeMirror typeMirror;

    AbstractClassType(ProcessingEnvironment processingEnv, TypeMirror typeMirror) {
        this.processingEnv = processingEnv;
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.typeMirror = typeMirror;
    }

    AbstractClassType(ProcessingEnvironment processingEnv, Element element) {
        this.processingEnv = processingEnv;
        this.elements = processingEnv.getElementUtils();
        this.types = processingEnv.getTypeUtils();
        this.typeMirror = element.asType();
    }

    @Override
    public final boolean isAssignableFrom(Class<?> type) {
        return this.types.isAssignable(this.types.erasure(this.toType(type)), this.types.erasure(this.typeMirror));
    }

    @Override
    public final boolean isSubtypeOf(Class<?> type) {
        return this.types.isSubtype(this.types.erasure(this.typeMirror), this.toType(type));
    }

    @Override
    public final boolean isSameAs(Class<?> type) {
        return this.types.isSameType(this.types.erasure(this.typeMirror), this.toType(type));
    }

    private TypeMirror toType(Class<?> type) {
        return this.types.erasure(ElementHelper.toType(this.elements, type));
    }
}

