/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import jakarta.resource.spi.security.GenericCredential;
import jakarta.resource.spi.security.PasswordCredential;
import org.glassfish.deployment.common.Descriptor;

public class AuthMechanism
extends Descriptor {
    private static final long serialVersionUID = 1L;
    public static final int BASIC_PASSWORD = 0;
    public static final int KERBV5 = 1;
    private int authMechVal;
    private String credInterface;

    public AuthMechanism() {
    }

    public AuthMechanism(int authMechVal) {
        super.setDescription("");
        this.authMechVal = authMechVal;
        this.credInterface = authMechVal == 0 ? PasswordCredential.class.getName() : GenericCredential.class.getName();
    }

    public AuthMechanism(String description, int authMechVal, String credInterface) {
        super.setDescription(description);
        this.authMechVal = authMechVal;
        this.credInterface = credInterface;
    }

    public void setCredentialInterface(String cred) {
        this.credInterface = cred;
    }

    public String getCredentialInterface() {
        return this.credInterface;
    }

    public String getDescription() {
        return super.getDescription();
    }

    public void setDescription(String description) {
        super.setDescription(description);
    }

    public String getAuthMechType() {
        if (this.authMechVal == 0) {
            return "BasicPassword";
        }
        return "Kerbv5";
    }

    public static int getAuthMechInt(String value) {
        if ("BasicPassword".equals(value.trim())) {
            return 0;
        }
        if ("Kerbv5".equals(value.trim())) {
            return 1;
        }
        throw new IllegalArgumentException("Invalid auth-mech-type");
    }

    public int getAuthMechVal() {
        return this.authMechVal;
    }

    public void setAuthMechVal(int value) {
        this.authMechVal = value;
    }

    public void setAuthMechVal(String value) {
        if ("BasicPassword".equals(value.trim())) {
            this.authMechVal = 0;
        } else if ("Kerbv5".equals(value.trim())) {
            this.authMechVal = 1;
        } else {
            throw new IllegalArgumentException("Invalid auth-mech-type");
        }
    }
}

