/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.mgmt.transport.grizzly.grizzly2;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.SocketConnectorHandler;
import org.glassfish.grizzly.utils.Exceptions;

public class ConnectionCache {
    private final SocketConnectorHandler socketConnectorHandler;
    private final int highWaterMark;
    private final int maxParallelConnections;
    private final int numberToReclaim;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final AtomicInteger totalCachedConnectionsCount = new AtomicInteger();
    private final ConcurrentHashMap<SocketAddress, CacheRecord> cache = new ConcurrentHashMap();
    private static final long connectTimeoutMillis = 5000L;
    private final Connection.CloseListener removeCachedConnectionOnCloseListener = new RemoveCachedConnectionOnCloseListener();

    public ConnectionCache(SocketConnectorHandler socketConnectorHandler, int highWaterMark, int maxParallelConnections, int numberToReclaim) {
        this.socketConnectorHandler = socketConnectorHandler;
        this.highWaterMark = highWaterMark;
        this.maxParallelConnections = maxParallelConnections;
        this.numberToReclaim = numberToReclaim;
    }

    public Connection poll(SocketAddress localAddress, SocketAddress remoteAddress) throws IOException {
        CacheRecord cacheRecord = this.obtainCacheRecord(remoteAddress);
        if (this.isClosed.get()) {
            this.cache.remove(remoteAddress, cacheRecord);
            this.closeCacheRecord(cacheRecord);
            throw new IOException("ConnectionCache is closed");
        }
        Connection connection = cacheRecord.connections.poll();
        if (connection != null) {
            connection.removeCloseListener(this.removeCachedConnectionOnCloseListener);
            cacheRecord.idleConnectionsCount.decrementAndGet();
            return connection;
        }
        Future connectFuture = this.socketConnectorHandler.connect((Object)remoteAddress, (Object)localAddress);
        try {
            connection = (Connection)connectFuture.get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            throw Exceptions.makeIOException((Throwable)e);
        }
        return connection;
    }

    public void offer(Connection connection) {
        SocketAddress remoteAddress = (SocketAddress)connection.getPeerAddress();
        CacheRecord cacheRecord = this.obtainCacheRecord(remoteAddress);
        int totalConnectionsN = this.totalCachedConnectionsCount.incrementAndGet();
        int parallelConnectionN = cacheRecord.idleConnectionsCount.incrementAndGet();
        if (totalConnectionsN > this.highWaterMark || parallelConnectionN > this.maxParallelConnections) {
            this.totalCachedConnectionsCount.decrementAndGet();
            cacheRecord.idleConnectionsCount.decrementAndGet();
        }
        connection.addCloseListener(this.removeCachedConnectionOnCloseListener);
        cacheRecord.connections.offer(connection);
        if (this.isClosed.get()) {
            this.cache.remove(remoteAddress, cacheRecord);
            this.closeCacheRecord(cacheRecord);
        }
    }

    public void close() {
        if (!this.isClosed.getAndSet(true)) {
            for (SocketAddress key : this.cache.keySet()) {
                CacheRecord cacheRecord = this.cache.remove(key);
                this.closeCacheRecord(cacheRecord);
            }
        }
    }

    private void closeCacheRecord(CacheRecord cacheRecord) {
        Connection connection;
        if (cacheRecord == null) {
            return;
        }
        while ((connection = cacheRecord.connections.poll()) != null) {
            cacheRecord.idleConnectionsCount.decrementAndGet();
            connection.close();
        }
    }

    private CacheRecord obtainCacheRecord(SocketAddress remoteAddress) {
        CacheRecord newCacheRecord;
        CacheRecord cacheRecord = this.cache.get(remoteAddress);
        if (cacheRecord == null && (cacheRecord = this.cache.putIfAbsent(remoteAddress, newCacheRecord = new CacheRecord())) == null) {
            cacheRecord = newCacheRecord;
        }
        return cacheRecord;
    }

    private final class RemoveCachedConnectionOnCloseListener
    implements Connection.CloseListener {
        private RemoveCachedConnectionOnCloseListener() {
        }

        public void onClosed(Connection connection, Connection.CloseType type) throws IOException {
            SocketAddress remoteAddress = (SocketAddress)connection.getPeerAddress();
            CacheRecord cacheRecord = ConnectionCache.this.cache.get(remoteAddress);
            if (cacheRecord != null && cacheRecord.connections.remove(connection)) {
                cacheRecord.idleConnectionsCount.decrementAndGet();
            }
        }
    }

    private static final class CacheRecord {
        final AtomicInteger idleConnectionsCount = new AtomicInteger();
        final Queue<Connection> connections = new LinkedTransferQueue<Connection>();

        private CacheRecord() {
        }
    }
}

