/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.iiop.security;

import com.sun.corba.ee.org.omg.CSI.AuthorizationElement;
import com.sun.corba.ee.org.omg.CSI.EstablishContext;
import com.sun.corba.ee.org.omg.CSI.GSS_NT_ExportedNameHelper;
import com.sun.corba.ee.org.omg.CSI.IdentityToken;
import com.sun.corba.ee.org.omg.CSI.SASContextBody;
import com.sun.corba.ee.org.omg.CSI.SASContextBodyHelper;
import com.sun.corba.ee.org.omg.CSI.X501DistinguishedNameHelper;
import com.sun.corba.ee.org.omg.CSI.X509CertificateChainHelper;
import com.sun.corba.ee.org.omg.CSIIOP.CompoundSecMech;
import com.sun.enterprise.common.iiop.security.AnonCredential;
import com.sun.enterprise.common.iiop.security.GSSUPName;
import com.sun.enterprise.common.iiop.security.SecurityContext;
import com.sun.enterprise.iiop.security.ConnectionContext;
import com.sun.enterprise.iiop.security.ConnectionExecutionContext;
import com.sun.enterprise.iiop.security.GSSUPToken;
import com.sun.enterprise.iiop.security.InvalidIdentityTokenException;
import com.sun.enterprise.iiop.security.InvalidMechanismException;
import com.sun.enterprise.iiop.security.Lookups;
import com.sun.enterprise.iiop.security.SecurityContextUtil;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.iiop.security.SvcContextUtils;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.x500.X500Principal;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.IOP.Codec;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;

public class SecClientRequestInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final Logger LOG = LogDomains.getLogger(SecClientRequestInterceptor.class, (String)"jakarta.enterprise.system.core.security", (boolean)false);
    private final String name;
    private final String prname;
    private final Codec codec;
    private final GlassFishORBHelper orbHelper;
    private final SecurityContextUtil secContextUtil;
    protected static final int SECURITY_ATTRIBUTE_SERVICE_ID = 15;

    public SecClientRequestInterceptor(String name, Codec codec) {
        this.name = name;
        this.codec = codec;
        this.prname = name + "::";
        this.orbHelper = Lookups.getGlassFishORBHelper();
        this.secContextUtil = Lookups.getSecurityContextUtil();
    }

    public String name() {
        return this.name;
    }

    private java.lang.Object getCred(Set credset, Class c) {
        java.lang.Object cred2 = null;
        String clsname = c.getName();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Checking for a single instance of class in subject");
            LOG.log(Level.FINE, "    Classname = " + clsname);
        }
        if (credset.size() != 1) {
            throw new SecurityException("Credential list size is not 1, but " + credset.size());
        }
        for (java.lang.Object cred2 : credset) {
        }
        LOG.log(Level.FINE, "Verified single instance of class {0}", clsname);
        return cred2;
    }

    private byte[] createAuthToken(java.lang.Object cred, Class cls, ORB orb, CompoundSecMech mech) throws Exception {
        byte[] gsstoken = new byte[]{};
        if (PasswordCredential.class.isAssignableFrom(cls)) {
            LOG.log(Level.FINE, "Constructing a PasswordCredential client auth token");
            PasswordCredential pwdcred = (PasswordCredential)cred;
            GSSUPToken tok = GSSUPToken.getClientSideInstance(orb, this.codec, pwdcred, mech);
            gsstoken = tok.getGSSToken();
        }
        return gsstoken;
    }

    private IdentityToken createIdToken(java.lang.Object cred, Class cls, ORB orb) throws Exception {
        IdentityToken idtok = null;
        Any any = orb.create_any();
        idtok = new IdentityToken();
        if (X500Principal.class.isAssignableFrom(cls)) {
            LOG.log(Level.FINE, "Constructing an X500 DN Identity Token");
            X500Principal x500Principal = (X500Principal)cred;
            X501DistinguishedNameHelper.insert((Any)any, (byte[])x500Principal.getEncoded());
            idtok.dn(this.codec.encode_value(any));
        } else if (X509CertificateCredential.class.isAssignableFrom(cls)) {
            LOG.log(Level.FINE, "Constructing an X509 Certificate Chain Identity Token");
            X509CertificateCredential certcred = (X509CertificateCredential)cred;
            X509Certificate[] certchain = certcred.getX509CertificateChain();
            LOG.log(Level.FINE, "Certchain length = {0}", certchain.length);
            byte[] certBytes = CertificateFactory.getInstance("X.509").generateCertPath(Arrays.asList(certchain)).getEncoded();
            X509CertificateChainHelper.insert((Any)any, (byte[])certBytes);
            idtok.certificate_chain(this.codec.encode_value(any));
        } else if (AnonCredential.class.isAssignableFrom(cls)) {
            LOG.log(Level.FINE, "Constructing an Anonymous Identity Token");
            idtok.anonymous(true);
        } else if (GSSUPName.class.isAssignableFrom(cls)) {
            LOG.log(Level.FINE, "Constructing a GSS Exported name Identity Token");
            GSSUPName gssname = (GSSUPName)cred;
            byte[] expname = gssname.getExportedName();
            GSS_NT_ExportedNameHelper.insert((Any)any, (byte[])expname);
            idtok.principal_name(this.codec.encode_value(any));
        }
        return idtok;
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        long cContextId = 0L;
        ConnectionExecutionContext.removeClientThreadID();
        AuthorizationElement[] cAuthzElem = new AuthorizationElement[]{};
        IdentityToken cIdentityToken = null;
        byte[] cAuthenticationToken = new byte[]{};
        byte[] cdr_encoded_saselm = null;
        java.lang.Object cred = null;
        LOG.log(Level.FINE, "++++ Entered {0} send_request()", this.prname);
        SecurityContext secctxt = null;
        ORB orb = this.orbHelper.getORB();
        Object effective_target = ri.effective_target();
        try {
            secctxt = this.secContextUtil.getSecurityContext(effective_target);
        }
        catch (InvalidMechanismException ime) {
            throw new RuntimeException(ime);
        }
        catch (InvalidIdentityTokenException iite) {
            throw new RuntimeException(iite);
        }
        if (secctxt == null) {
            LOG.log(Level.FINE, "Security context is null (nothing to add to service context)");
            return;
        }
        SecurityContext sCtx = secctxt;
        if (secctxt.authcls != null) {
            PrivilegedAction<java.lang.Object> action = () -> {
                Set credentials = sCtx.subject.getPrivateCredentials(sCtx.authcls);
                return this.getCred(credentials, sCtx.authcls);
            };
            cred = AccessController.doPrivileged(action);
            try {
                SecurityMechanismSelector sms = Lookups.getSecurityMechanismSelector();
                ConnectionContext cc = sms.getClientConnectionContext();
                CompoundSecMech mech = cc.getMechanism();
                cAuthenticationToken = this.createAuthToken(cred, secctxt.authcls, orb, mech);
            }
            catch (Exception e) {
                throw new SecurityException("Error while constructing an authentication token.");
            }
        }
        if (secctxt.identcls != null) {
            cred = this.getCred(secctxt.subject.getPublicCredentials(secctxt.identcls), secctxt.identcls);
            try {
                cIdentityToken = this.createIdToken(cred, secctxt.identcls, orb);
            }
            catch (Exception e) {
                throw new SecurityException("Error while constructing an identity token.");
            }
        } else {
            LOG.log(Level.FINE, "Constructing an Absent Identity Token");
            cIdentityToken = new IdentityToken();
            cIdentityToken.absent(true);
        }
        LOG.log(Level.FINE, "Creating an EstablishContext message");
        EstablishContext ec = new EstablishContext(cContextId, cAuthzElem, cIdentityToken, cAuthenticationToken);
        SASContextBody sasctxbody = new SASContextBody();
        sasctxbody.establish_msg(ec);
        Any SasAny = orb.create_any();
        SASContextBodyHelper.insert((Any)SasAny, (SASContextBody)sasctxbody);
        try {
            cdr_encoded_saselm = this.codec.encode_value(SasAny);
        }
        catch (Exception e) {
            throw new SecurityException("CDR Encoding error for a SAS context element.", e);
        }
        ServiceContext sc = new ServiceContext();
        sc.context_id = 15;
        sc.context_data = cdr_encoded_saselm;
        LOG.log(Level.FINE, "Adding EstablishContext message to service context list");
        boolean no_replace = false;
        ri.add_request_service_context(sc, no_replace);
        LOG.log(Level.FINE, "Added EstablishContext message to service context list");
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    private void setreplyStatus(int status, Object target) {
        LOG.log(Level.FINE, "Status to be set: {0}", status);
        SecurityContextUtil.receivedReply(status, target);
        LOG.log(Level.FINE, "Invoked receivedReply()");
    }

    private int mapreplyStatus(int repst) {
        LOG.log(Level.FINE, "Reply status to be mapped = {0}", repst);
        int status = switch (repst) {
            case 0, 2 -> 0;
            case 3, 4 -> 2;
            case 1 -> 1;
            default -> repst;
        };
        LOG.log(Level.FINE, "Mapped reply status = {0}", status);
        return status;
    }

    private void handle_null_service_context(ClientRequestInfo ri) {
        LOG.log(Level.FINE, "No SAS context element found in service context list");
        this.setreplyStatus(0, ri.effective_target());
    }

    public void receive_reply(ClientRequestInfo ri) {
        Any a;
        ServiceContext sc = null;
        int status = -1;
        LOG.log(Level.FINE, "Entered {0} receive_reply", this.prname);
        try {
            sc = ri.get_reply_service_context(15);
            if (sc == null) {
                this.handle_null_service_context(ri);
                return;
            }
        }
        catch (BAD_PARAM e) {
            this.handle_null_service_context(ri);
            return;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Could not get the service context for id=15", ex);
            return;
        }
        try {
            a = this.codec.decode_value(sc.context_data, SASContextBodyHelper.type());
        }
        catch (Exception e) {
            throw new SecurityException("CDR Decoding error for SAS context element.", e);
        }
        SASContextBody sasctxbody = SASContextBodyHelper.extract((Any)a);
        short sasdiscr = sasctxbody.discriminator();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Received " + SvcContextUtils.getMsgname(sasdiscr) + " message");
        }
        LOG.log(Level.FINE, "Verifying the SAS protocol reply message");
        if (sasdiscr != 1 && sasdiscr != 4) {
            throw new SecurityException("Reply message not one of CompleteEstablishContext or ContextError: " + sasdiscr);
        }
        int st = this.mapreplyStatus(ri.reply_status());
        this.setreplyStatus(st, ri.effective_target());
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        LOG.log(Level.FINE, "Entered {0} receive_exception", this.prname);
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
    }

    public void destroy() {
    }

    protected GlassFishORBHelper getORBHelper() {
        return this.orbHelper;
    }
}

