/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.PacketProperties;
import com.sun.messaging.jmq.util.io.FilteringObjectInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Hashtable;

public class PacketPayload {
    private static final System.Logger logger = System.getLogger(PacketPayload.class.getName());
    protected ByteBuffer propBuf_v1 = null;
    protected ByteBuffer propBuf_v2 = null;
    protected Hashtable properties = null;
    protected ByteBuffer bodyBuf = null;

    public PacketPayload() {
        this.reset();
    }

    public synchronized void reset() {
        this.propBuf_v1 = null;
        this.propBuf_v2 = null;
        this.properties = null;
        this.bodyBuf = null;
    }

    public synchronized ByteBuffer getBodyBytes() {
        if (this.bodyBuf == null) {
            return null;
        }
        this.bodyBuf.rewind();
        return this.bodyBuf;
    }

    public int getBodySize() {
        if (this.bodyBuf == null) {
            return 0;
        }
        return this.bodyBuf.limit();
    }

    public InputStream getBodyStream() {
        if (this.bodyBuf == null) {
            return null;
        }
        return new JMQByteBufferInputStream(this.getBodyBytes());
    }

    public synchronized Hashtable getProperties() throws IOException, ClassNotFoundException {
        if (this.properties != null) {
            return this.properties;
        }
        ByteBuffer propBuf = this.propBuf_v2;
        short version = 301;
        if (propBuf == null && this.propBuf_v1 != null) {
            propBuf = this.propBuf_v1;
            version = 200;
        }
        if (propBuf != null) {
            propBuf.rewind();
            try {
                InputStream is = this.getPropertiesStream(version);
                this.properties = version >= 301 ? PacketProperties.parseProperties(is) : this.parseProperties(is);
            }
            catch (IOException | ClassNotFoundException e) {
                logger.log(System.Logger.Level.ERROR, "Could not parse properties " + e.getMessage(), (Throwable)e);
                throw e;
            }
            return this.properties;
        }
        return null;
    }

    public synchronized ByteBuffer getPropertiesBytes(short version) {
        ByteBuffer propBuf;
        if (this.propBuf_v1 == null && this.propBuf_v2 == null && this.properties == null) {
            return null;
        }
        ByteBuffer byteBuffer = propBuf = version >= 301 ? this.propBuf_v2 : this.propBuf_v1;
        if (propBuf == null && this.properties == null) {
            try {
                this.getProperties();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, ex.getMessage(), (Throwable)ex);
            }
        }
        if (propBuf == null) {
            JMQByteArrayOutputStream bos = new JMQByteArrayOutputStream(new byte[256]);
            try {
                if (version >= 301) {
                    PacketProperties.write(this.properties, bos);
                } else {
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(this.properties);
                    oos.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Could not marshal properties " + e.getMessage(), (Throwable)e);
            }
            propBuf = ByteBuffer.wrap(bos.getBuf(), 0, bos.getCount());
        }
        propBuf.rewind();
        return propBuf;
    }

    public InputStream getPropertiesStream(short version) {
        ByteBuffer buf = this.getPropertiesBytes(version);
        if (buf == null) {
            return null;
        }
        return new JMQByteBufferInputStream(buf);
    }

    public synchronized void setBody(ByteBuffer body) {
        if (body == null) {
            this.bodyBuf = null;
        } else {
            this.bodyBuf = body;
            this.bodyBuf.rewind();
        }
    }

    public synchronized void setProperties(Hashtable props) {
        this.properties = props;
        this.propBuf_v1 = null;
        this.propBuf_v2 = null;
    }

    public synchronized void setPropertiesBytes(ByteBuffer buf, short version) {
        if (buf == null) {
            this.propBuf_v1 = null;
            this.propBuf_v2 = null;
        } else {
            ByteBuffer propBuf = null;
            propBuf = version >= 301 ? (this.propBuf_v2 = buf) : (this.propBuf_v1 = buf);
            propBuf.rewind();
        }
        this.properties = null;
    }

    private Hashtable parseProperties(InputStream is) throws IOException, ClassNotFoundException {
        FilteringObjectInputStream p = new FilteringObjectInputStream(is);
        return (Hashtable)p.readObject();
    }
}

