/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.partition.api;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionWork;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.api.TransactionInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Contract;

@Contract
@PerLookup
public abstract class AbstractPartitionedStore
implements PartitionedStore {
    protected static final Logger logger = Globals.getLogger();
    protected static final BrokerResources br = Globals.getBrokerResources();
    protected boolean closed = false;
    private Object closedLock = new Object();
    private int inprogressCount = 0;
    private Object inprogressLock = new Object();
    protected Store parent = null;
    protected UID partitionid = null;
    protected boolean isPrimary = false;

    @Override
    public void init(Store store, UID id, boolean isPrimary) throws BrokerException {
        this.parent = store;
        this.partitionid = id;
        this.isPrimary = isPrimary;
    }

    @Override
    public UID getPartitionID() {
        return this.partitionid;
    }

    @Override
    public boolean isPrimaryPartition() {
        return this.isPrimary;
    }

    @Override
    public abstract void storeMessage(DestinationUID var1, Packet var2, ConsumerUID[] var3, int[] var4, boolean var5) throws IOException, BrokerException;

    @Override
    public abstract void storeMessage(DestinationUID var1, Packet var2, boolean var3) throws IOException, BrokerException;

    @Override
    public void removeMessage(DestinationUID dID, SysMessageID mID, boolean sync) throws IOException, BrokerException {
        this.removeMessage(dID, mID, sync, false);
    }

    @Override
    public void removeMessage(DestinationUID dID, String id, boolean sync) throws IOException, BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.parent.getStoreType() + " store");
    }

    @Override
    public abstract void removeMessage(DestinationUID var1, SysMessageID var2, boolean var3, boolean var4) throws IOException, BrokerException;

    @Override
    public abstract void moveMessage(Packet var1, DestinationUID var2, DestinationUID var3, ConsumerUID[] var4, int[] var5, boolean var6) throws IOException, BrokerException;

    @Override
    public void repairCorruptedSysMessageID(SysMessageID realSysId, String badSysIdStr, String duidStr, boolean sync) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.parent.getStoreType() + " store");
    }

    @Override
    public abstract Enumeration messageEnumeration(Destination var1) throws BrokerException;

    @Override
    public void closeEnumeration(Enumeration en) {
    }

    @Override
    public abstract boolean hasMessageBeenAcked(DestinationUID var1, SysMessageID var2) throws BrokerException;

    @Override
    public abstract HashMap getMessageStorageInfo(Destination var1) throws BrokerException;

    @Override
    public abstract Packet getMessage(DestinationUID var1, String var2) throws BrokerException;

    @Override
    public abstract Packet getMessage(DestinationUID var1, SysMessageID var2) throws BrokerException;

    @Override
    public abstract void storeInterestStates(DestinationUID var1, SysMessageID var2, ConsumerUID[] var3, int[] var4, boolean var5, Packet var6) throws BrokerException;

    @Override
    public abstract void updateInterestState(DestinationUID var1, SysMessageID var2, ConsumerUID var3, int var4, boolean var5, TransactionUID var6, boolean var7) throws BrokerException;

    @Override
    public abstract int getInterestState(DestinationUID var1, SysMessageID var2, ConsumerUID var3) throws BrokerException;

    @Override
    public abstract HashMap getInterestStates(DestinationUID var1, SysMessageID var2) throws BrokerException;

    @Override
    public abstract ConsumerUID[] getConsumerUIDs(DestinationUID var1, SysMessageID var2) throws BrokerException;

    @Override
    public abstract void storeDestination(Destination var1, boolean var2) throws IOException, BrokerException;

    @Override
    public abstract void updateDestination(Destination var1, boolean var2) throws BrokerException;

    @Override
    public abstract void removeDestination(Destination var1, boolean var2) throws IOException, BrokerException;

    @Override
    public long getDestinationConnectedTime(Destination destination) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.parent.getStoreType() + " store");
    }

    @Override
    public abstract Destination getDestination(DestinationUID var1) throws IOException, BrokerException;

    @Override
    public abstract Destination[] getAllDestinations() throws IOException, BrokerException;

    @Override
    public abstract void storeTransaction(TransactionUID var1, TransactionState var2, boolean var3) throws IOException, BrokerException;

    @Override
    public abstract void storeClusterTransaction(TransactionUID var1, TransactionState var2, TransactionBroker[] var3, boolean var4) throws BrokerException;

    @Override
    public abstract void storeRemoteTransaction(TransactionUID var1, TransactionState var2, TransactionAcknowledgement[] var3, BrokerAddress var4, boolean var5) throws BrokerException;

    @Override
    public abstract void removeTransaction(TransactionUID var1, boolean var2, boolean var3) throws IOException, BrokerException;

    @Override
    public abstract void updateTransactionState(TransactionUID var1, TransactionState var2, boolean var3) throws IOException, BrokerException;

    @Override
    public abstract void updateTransactionStateWithWork(TransactionUID var1, TransactionState var2, TransactionWork var3, boolean var4) throws IOException, BrokerException;

    @Override
    public abstract void updateClusterTransaction(TransactionUID var1, TransactionBroker[] var2, boolean var3) throws BrokerException;

    @Override
    public abstract void updateClusterTransactionBrokerState(TransactionUID var1, int var2, TransactionBroker var3, boolean var4) throws BrokerException;

    @Override
    public void updateRemoteTransaction(TransactionUID txnUID, TransactionAcknowledgement[] txnAcks, BrokerAddress txnHomeBroker, boolean sync) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.parent.getStoreType() + " store");
    }

    @Override
    public abstract TransactionState getTransactionState(TransactionUID var1) throws BrokerException;

    @Override
    public int[] getTransactionUsageInfo(TransactionUID txnID) throws BrokerException {
        throw new UnsupportedOperationException("Operation not supported by the " + this.parent.getStoreType() + " store");
    }

    @Override
    public abstract TransactionBroker[] getClusterTransactionBrokers(TransactionUID var1) throws BrokerException;

    @Override
    public abstract BrokerAddress getRemoteTransactionHomeBroker(TransactionUID var1) throws BrokerException;

    @Override
    public abstract TransactionInfo getTransactionInfo(TransactionUID var1) throws BrokerException;

    @Override
    public abstract HashMap getAllTransactionStates() throws IOException, BrokerException;

    @Override
    public abstract HashMap getAllRemoteTransactionStates() throws IOException, BrokerException;

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public abstract void close(boolean var1);

    @Override
    public abstract void storeTransactionAck(TransactionUID var1, TransactionAcknowledgement var2, boolean var3) throws BrokerException;

    @Override
    public abstract void removeTransactionAck(TransactionUID var1, boolean var2) throws BrokerException;

    @Override
    public abstract TransactionAcknowledgement[] getTransactionAcks(TransactionUID var1) throws BrokerException;

    @Override
    public abstract HashMap getAllTransactionAcks() throws BrokerException;

    @Override
    public abstract Hashtable getDebugState() throws BrokerException;

    @Override
    public LoadException getLoadDestinationException() {
        return null;
    }

    @Override
    public LoadException getLoadTransactionException() {
        return null;
    }

    @Override
    public LoadException getLoadTransactionAckException() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setClosedAndWait() {
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = true;
        }
        this.beforeWaitOnClose();
        object = this.inprogressLock;
        synchronized (object) {
            while (this.inprogressCount > 0) {
                try {
                    this.inprogressLock.wait();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void beforeWaitOnClose() {
    }

    protected void checkClosedAndSetInProgress() throws BrokerException {
        this.checkClosedAndSetInProgress(32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkClosedAndSetInProgress(int loglevel) throws BrokerException {
        Object object = this.closedLock;
        synchronized (object) {
            if (this.closed) {
                logger.log(loglevel, "B3102");
                throw new BrokerException(br.getString("B3102"), 405);
            }
            this.setInProgress(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInProgress(boolean flag) {
        Object object = this.inprogressLock;
        synchronized (object) {
            this.inprogressCount = flag ? ++this.inprogressCount : --this.inprogressCount;
            if (this.inprogressCount == 0) {
                this.inprogressLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.closedLock;
        synchronized (object) {
            return this.closed;
        }
    }

    public String toString() {
        return "StorePartition[" + String.valueOf(this.partitionid) + "]closed=" + this.closed;
    }

    public int hashCode() {
        return this.partitionid.hashCode();
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (!(anObject instanceof PartitionedStore)) {
            return false;
        }
        return this.getPartitionID().equals((Object)((PartitionedStore)anObject).getPartitionID());
    }
}

