/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.statistics.impl;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.glassfish.flashlight.datatree.impl.AbstractTreeNode;
import org.glassfish.flashlight.statistics.Counter;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="counter")
@PerLookup
public class CounterImpl
extends AbstractTreeNode
implements Counter {
    public static final long DEFAULT_MAX_BOUND = Long.MAX_VALUE;
    public static final long DEFAULT_VALUE;
    public static final long DEFAULT_MIN_BOUND;
    protected static final String NEWLINE;
    private AtomicLong count = new AtomicLong(0L);
    long max = 0L;
    long min = 0L;
    private AtomicLong lastSampleTime = new AtomicLong();
    private String DESCRIPTION = "Counter CountStatistic";
    private String UNIT = Long.class.toString();
    private long startTime = System.currentTimeMillis();

    @Override
    public long getCount() {
        return this.count.get();
    }

    @Override
    public void setCount(long count) {
        if (count > this.max) {
            this.max = count;
        } else {
            this.min = count;
        }
        this.count.set(count);
    }

    @Override
    public void increment() {
        long cnt = this.count.incrementAndGet();
        if (cnt > this.max) {
            this.max = cnt;
        }
        this.lastSampleTime.set(this.getSampleTime());
    }

    @Override
    public void increment(long delta) {
        long cnt = this.count.addAndGet(delta);
        if (cnt > this.max) {
            this.max = cnt;
        }
        this.lastSampleTime.set(this.getSampleTime());
    }

    @Override
    public void decrement() {
        long cnt = this.count.decrementAndGet();
        if (cnt < this.min) {
            this.min = cnt;
        }
    }

    @Override
    public void setReset(boolean reset) {
        if (reset) {
            this.count.set(0L);
        }
    }

    @Override
    public Object getValue() {
        return this.getCount();
    }

    public String getUnit() {
        return this.UNIT;
    }

    @Override
    public String getDescription() {
        return this.DESCRIPTION;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getLastSampleTime() {
        return this.lastSampleTime.longValue();
    }

    private long getSampleTime() {
        return System.currentTimeMillis();
    }

    static {
        DEFAULT_MIN_BOUND = DEFAULT_VALUE = BigInteger.ZERO.longValue();
        NEWLINE = System.getProperty("line.separator");
    }
}

