/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.microprofile.restclient;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Optional;
import java.util.function.Supplier;

final class HeadersContext {
    private static final ThreadLocal<HeadersContext> HEADERS_CONTEXT = new ThreadLocal();
    private final MultivaluedMap<String, String> inboundHeaders;

    static Optional<HeadersContext> get() {
        return Optional.ofNullable(HEADERS_CONTEXT.get());
    }

    static HeadersContext compute(Supplier<HeadersContext> contextSupplier) {
        HeadersContext headersContext = HEADERS_CONTEXT.get();
        if (null == headersContext) {
            HeadersContext.set(contextSupplier.get());
        }
        return HeadersContext.get().orElseThrow(() -> new IllegalStateException("Computed result was null"));
    }

    static void set(HeadersContext context) {
        HEADERS_CONTEXT.set(context);
    }

    static void remove() {
        HEADERS_CONTEXT.remove();
    }

    static HeadersContext create(MultivaluedMap<String, String> inboundHeaders) {
        return new HeadersContext(inboundHeaders);
    }

    private HeadersContext(MultivaluedMap<String, String> inboundHeaders) {
        this.inboundHeaders = inboundHeaders;
    }

    MultivaluedMap<String, String> inboundHeaders() {
        return this.inboundHeaders;
    }
}

